/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EncryptionUtil {
    private static final String ALGORITHM = "AES";
    private static final String TRANSFORMATION = "AES/CBC/PKCS5Padding";
    private static final String KEY = "F575u8mktb74gEYl";

    private static IvParameterSpec generateIv() {
        byte[] iv = new byte[16];
        new SecureRandom().nextBytes(iv);
        return new IvParameterSpec(iv);
    }

    public static String encrypt(String value) throws Exception {
        SecretKeySpec key = new SecretKeySpec(KEY.getBytes(StandardCharsets.UTF_8), ALGORITHM);
        Cipher cipher = Cipher.getInstance(TRANSFORMATION);
        IvParameterSpec iv = EncryptionUtil.generateIv();
        cipher.init(1, (Key)key, iv);
        byte[] encrypted = cipher.doFinal(value.getBytes(StandardCharsets.UTF_8));
        byte[] ivAndEncrypted = EncryptionUtil.concatenate(iv.getIV(), encrypted);
        return Base64.getEncoder().encodeToString(ivAndEncrypted);
    }

    public static String decrypt(String encrypted) throws Exception {
        try {
            byte[] decodedValue = Base64.getDecoder().decode(encrypted);
            SecretKeySpec key = new SecretKeySpec(KEY.getBytes(StandardCharsets.UTF_8), ALGORITHM);
            IvParameterSpec iv = new IvParameterSpec(decodedValue, 0, 16);
            byte[] encryptedBytes = new byte[decodedValue.length - 16];
            System.arraycopy(decodedValue, 16, encryptedBytes, 0, encryptedBytes.length);
            Cipher cipher = Cipher.getInstance(TRANSFORMATION);
            cipher.init(2, (Key)key, iv);
            byte[] original = cipher.doFinal(encryptedBytes);
            return new String(original, StandardCharsets.UTF_8);
        }
        catch (IllegalArgumentException e) {
            System.out.println(encrypted);
            throw new RuntimeException("Failed to decode Base64 string. Please check the input.", e);
        }
    }

    private static byte[] concatenate(byte[] iv, byte[] encrypted) {
        byte[] result = new byte[iv.length + encrypted.length];
        System.arraycopy(iv, 0, result, 0, iv.length);
        System.arraycopy(encrypted, 0, result, iv.length, encrypted.length);
        return result;
    }
}

