/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class ExecutorsUtils {
    private ScheduledExecutorService executorService;

    public ScheduledExecutorService createScheduledThreadPool(int threads, Runnable runnable, int delay, int period, TimeUnit timeUnit) {
        this.shutdown();
        this.executorService = Executors.newScheduledThreadPool(threads);
        this.executorService.scheduleAtFixedRate(runnable, delay, period, timeUnit);
        return this.executorService;
    }

    public ScheduledExecutorService createSingleThreadScheduledExecutor(Runnable runnable, int delay, int period, TimeUnit timeUnit) {
        this.shutdown();
        this.executorService = Executors.newSingleThreadScheduledExecutor();
        this.executorService.scheduleAtFixedRate(runnable, delay, period, timeUnit);
        return this.executorService;
    }

    public void shutdown() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdown();
        }
    }

    public void shutdownNow() {
        if (this.executorService != null && !this.executorService.isShutdown()) {
            this.executorService.shutdownNow();
        }
    }

    public boolean isRunning() {
        return this.executorService != null && !this.executorService.isShutdown();
    }
}

