/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

import ch.framedev.simplejavautils.Converter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TextUtils
extends Converter {
    public String replaceAndWithParagraph(String text) {
        if (text == null) {
            return null;
        }
        if (text.contains("&")) {
            text = text.replace('&', '\u00a7');
        }
        return text;
    }

    public String replaceObject(String text, String format, Object data) {
        if (text == null) {
            return null;
        }
        if (text.contains(format)) {
            text = text.replace(format, String.valueOf(data));
        }
        return text;
    }

    public <T> List<T> arrayToList(T[] array) {
        return new ArrayList<T>(Arrays.asList(array));
    }

    public String[] stringListToArray(List<String> list) {
        return list.toArray(new String[0]);
    }

    public Integer[] intListToArray(List<Integer> list) {
        return list.toArray(new Integer[0]);
    }

    public Double[] doubleListToArray(List<Double> list) {
        return list.toArray(new Double[0]);
    }

    public Float[] floatListToArray(List<Float> list) {
        return list.toArray(new Float[0]);
    }

    public Short[] shortListToArray(List<Short> list) {
        return list.toArray(new Short[0]);
    }

    public Long[] longListToArray(List<Long> list) {
        return list.toArray(new Long[0]);
    }

    public Byte[] byteListToArray(List<Byte> list) {
        return list.toArray(new Byte[0]);
    }

    public Object[] objectListToArray(List<Object> list) {
        return list.toArray(new Object[0]);
    }

    public <T> T[] listToArray(List<T> list, Class<T> clazz) {
        Object[] array = (Object[])Array.newInstance(clazz, list.size());
        return list.toArray(array);
    }

    public int doubleToInt(double d) {
        return (int)d;
    }

    public int longToInt(long number) {
        return (int)number;
    }

    public int floatToInt(float number) {
        return (int)number;
    }

    public String centerTextWithSymbol(String text, char symbol, int length) {
        int i;
        int half = length / 2;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < half; ++i) {
            sb.append(symbol);
        }
        sb.append(text);
        for (i = 0; i < half; ++i) {
            sb.append(symbol);
        }
        return sb.toString();
    }

    public void printBox(String ... text) {
        ArrayList<String> lines = new ArrayList<String>();
        int lastLength = 0;
        for (String t : text) {
            if (lastLength <= t.length()) {
                lastLength = t.length();
            }
            lines.add(t);
        }
        this.topBottomVoid(lastLength);
        for (String s : lines) {
            int spaces = lastLength - s.length();
            if (!s.contains("[") || !s.contains("]")) {
                System.out.print("| " + s);
            } else {
                String updated = s;
                int updatedSpaces = spaces / 2;
                for (int i = 0; i < updatedSpaces; ++i) {
                    updated = " " + updated;
                }
                System.out.print("| " + updated);
                spaces = updatedSpaces;
            }
            while (spaces-- > 0) {
                System.out.print(" ");
            }
            System.out.println(" |");
        }
        this.topBottomVoid(lastLength);
    }

    public String topBottom(int length) {
        StringBuilder lineBuilder = new StringBuilder();
        lineBuilder.append("+");
        for (int i = 0; i < length + 2; ++i) {
            lineBuilder.append("-");
        }
        lineBuilder.append("+\n");
        return lineBuilder.toString();
    }

    public void topBottomVoid(int length) {
        System.out.print("+");
        for (int i = 0; i <= length + 1; ++i) {
            System.out.print("-");
        }
        System.out.println("+");
    }

    public String generateBox(String ... text) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int lastLength = 0;
        for (String t : text) {
            if (lastLength < t.length()) {
                lastLength = t.length();
            }
            lines.add(t);
        }
        sb.append(this.topBottom(lastLength));
        for (String s : lines) {
            int spaces = lastLength - s.length();
            if (!s.contains("[") || !s.contains("]")) {
                sb.append("| ").append(s);
                int addedSpaces = 0;
                while (spaces-- > 0) {
                    sb.append(" ");
                    ++addedSpaces;
                }
            } else {
                String updated = s;
                int updatedSpaces = spaces / 2;
                for (int i = 0; i < updatedSpaces; ++i) {
                    updated = " " + updated;
                }
                sb.append("| ").append(updated);
                spaces = lastLength - s.length() - updatedSpaces;
                while (spaces-- > 0) {
                    sb.append(" ");
                }
            }
            sb.append(" |\n");
        }
        sb.append(this.topBottom(lastLength));
        return sb.toString();
    }

    public double milesToMeters(double miles) {
        return miles * 1609.344;
    }

    public double metersToMiles(double meters) {
        return meters / 1609.344;
    }
}

