/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReflectionUtils {
    private final Logger logger = Logger.getLogger("ReflectionUtils");
    private boolean accessible = false;

    public ReflectionUtils() {
    }

    public ReflectionUtils(boolean accessible) {
        this.accessible = accessible;
    }

    public String getClassName(Class<?> class_) {
        return class_.getPackage().getName() + "." + class_.getSimpleName();
    }

    public Object getEnumValue(String className, String of) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        assert (cls != null);
        for (Object obj : cls.getEnumConstants()) {
            try {
                Method m = cls.getMethod("valueOf", String.class);
                m.setAccessible(this.accessible);
                return m.invoke(obj, of);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException ex) {
                this.logger.log(Level.SEVERE, "Error", ex);
            }
        }
        return null;
    }

    public Object[] getEnumValues(String className) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        assert (cls != null);
        if (cls.isEnum()) {
            return cls.getEnumConstants();
        }
        return null;
    }

    public Field getField(String className, String fieldName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Field method : cls.getDeclaredFields()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(fieldName)) continue;
                return method;
            }
        }
        catch (SecurityException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return null;
    }

    public Field getFieldSuperClass(String className, String fieldName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Field method : cls.getSuperclass().getDeclaredFields()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(fieldName)) continue;
                return method;
            }
        }
        catch (SecurityException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return null;
    }

    public boolean hasConstructorAnnotation(Constructor<?> constructor, Class<? extends Annotation> class__) {
        constructor.setAccessible(this.accessible);
        return constructor.getAnnotation(class__) != null;
    }

    public boolean hasClassAnnotation(String className, Class<? extends Annotation> class__) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            return cls.getDeclaredAnnotation(class__) != null;
        }
        catch (SecurityException e) {
            this.logger.log(Level.SEVERE, "Error", e);
            return false;
        }
    }

    public boolean hasClassAnnotationSuperClass(String className, Class<? extends Annotation> class__) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            return cls.getSuperclass().getDeclaredAnnotation(class__) != null;
        }
        catch (SecurityException e) {
            this.logger.log(Level.SEVERE, "Error", e);
            return false;
        }
    }

    public boolean hasFieldAnnotation(String className, String fieldName, Class<? extends Annotation> class__) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Field field : cls.getDeclaredFields()) {
                field.setAccessible(true);
                if (!field.getName().equalsIgnoreCase(fieldName)) continue;
                return field.getAnnotation(class__) != null;
            }
        }
        catch (SecurityException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return false;
    }

    public boolean hasFieldAnnotationSuperClass(String className, String fieldName, Class<? extends Annotation> class__) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Field field : cls.getSuperclass().getDeclaredFields()) {
                field.setAccessible(this.accessible);
                if (!field.getName().equalsIgnoreCase(fieldName)) continue;
                return field.getAnnotation(class__) != null;
            }
        }
        catch (SecurityException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return false;
    }

    public Annotation[] getFieldAnnotations(String className, String fieldName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Field field : cls.getDeclaredFields()) {
                field.setAccessible(this.accessible);
                if (!field.getName().equalsIgnoreCase(fieldName)) continue;
                return field.getAnnotations();
            }
        }
        catch (SecurityException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return null;
    }

    public Annotation[] getFieldAnnotationsSuperClass(String className, String fieldName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Field field : cls.getSuperclass().getDeclaredFields()) {
                field.setAccessible(this.accessible);
                if (!field.getName().equalsIgnoreCase(fieldName)) continue;
                return field.getAnnotations();
            }
        }
        catch (SecurityException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return null;
    }

    public Annotation[] getMethodAnnotations(String className, String methodName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Method method : cls.getDeclaredMethods()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method.getAnnotations();
            }
        }
        catch (SecurityException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return null;
    }

    public Annotation[] getMethodAnnotationsSuperClass(String className, String methodName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Method method : cls.getSuperclass().getDeclaredMethods()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method.getAnnotations();
            }
        }
        catch (SecurityException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return null;
    }

    public boolean hasAnnotation(String className, String methodName, Class<? extends Annotation> class__) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Method method : cls.getDeclaredMethods()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(methodName) || method.getAnnotation(class__) == null) continue;
                return true;
            }
        }
        catch (SecurityException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return false;
    }

    public boolean hasAnnotationSuperClass(String className, String methodName, Class<? extends Annotation> class__) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Method method : cls.getSuperclass().getDeclaredMethods()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(methodName) || method.getAnnotation(class__) == null) continue;
                return true;
            }
        }
        catch (SecurityException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return false;
    }

    public Method getMethod(String className, String methodName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Method method : cls.getDeclaredMethods()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method;
            }
        }
        catch (SecurityException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return null;
    }

    public Method getMethodSuperClass(String className, String methodName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Method method : cls.getSuperclass().getDeclaredMethods()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method;
            }
        }
        catch (SecurityException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return null;
    }

    public List<Type> getParameterTypes(String className, String methodName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Method method : cls.getDeclaredMethods()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return Arrays.asList(method.getParameterTypes());
            }
        }
        catch (SecurityException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return null;
    }

    public List<Type> getParameterTypesSuperClass(String className, String methodName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Method method : cls.getSuperclass().getDeclaredMethods()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return Arrays.asList(method.getParameterTypes());
            }
        }
        catch (SecurityException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return null;
    }

    public Object runMethod(String className, Object object, String methodName, Object ... args) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Method method : cls.getDeclaredMethods()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method.invoke(object, args);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return null;
    }

    public Object runMethodSupClass(String className, Object object, String methodName, Object ... args) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Method method : cls.getSuperclass().getDeclaredMethods()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method.invoke(object, args);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return null;
    }

    public Object runMethod(String className, Object object, String methodName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Method method : cls.getDeclaredMethods()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method.invoke(object, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return null;
    }

    public Object runMethodSuperClass(String className, Object object, String methodName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Method method : cls.getSuperclass().getDeclaredMethods()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method.invoke(object, new Object[0]);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return null;
    }

    public boolean isVoidMethod(String className, Object object, String methodName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Method method : cls.getDeclaredMethods()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method.invoke(object, new Object[0]) == null;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return true;
    }

    public boolean isVoidMethodSuperClass(String className, Object object, String methodName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Method method : cls.getSuperclass().getDeclaredMethods()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method.invoke(object, new Object[0]) == null;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return true;
    }

    public boolean isVoidMethod(String className, Object object, String methodName, Object ... args) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Method method : cls.getDeclaredMethods()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method.invoke(object, args) == null;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return true;
    }

    public boolean isVoidMethodSuperClass(String className, Object object, String methodName, Object ... args) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Method method : cls.getSuperclass().getDeclaredMethods()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method.invoke(object, args) == null;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return true;
    }

    public boolean hasMethodArguments(String className, String methodName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Method method : cls.getDeclaredMethods()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method.getParameterCount() > 0;
            }
        }
        catch (IllegalArgumentException | SecurityException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return false;
    }

    public boolean hasMethodArgumentsSuperClass(String className, String methodName) {
        Class<?> cls = null;
        try {
            cls = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        try {
            assert (cls != null);
            for (Method method : cls.getSuperclass().getDeclaredMethods()) {
                method.setAccessible(this.accessible);
                if (!method.getName().equalsIgnoreCase(methodName)) continue;
                return method.getParameterCount() > 0;
            }
        }
        catch (IllegalArgumentException | SecurityException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return false;
    }

    public void setField(String className, Object object, String fieldName, Object data) {
        Field field = this.getField(className, fieldName);
        if (field == null) {
            this.logger.log(Level.SEVERE, "Error");
            return;
        }
        try {
            field.setAccessible(true);
            field.set(object, data);
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
    }

    public void setFieldSuperClass(String className, Object object, String fieldName, Object data) {
        Field field = this.getFieldSuperClass(className, fieldName);
        if (field == null) {
            this.logger.log(Level.SEVERE, "Error");
            return;
        }
        try {
            field.setAccessible(true);
            field.set(object, data);
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
    }

    public Object getFieldValue(String className, Object object, String fieldName) {
        Field field = this.getField(className, fieldName);
        if (field == null) {
            this.logger.log(Level.SEVERE, "Error");
            return null;
        }
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error", e);
            return null;
        }
    }

    public Object getFieldValueSuperClass(String className, Object object, String fieldName) {
        Field field = this.getFieldSuperClass(className, fieldName);
        if (field == null) {
            this.logger.log(Level.SEVERE, "Error");
            return null;
        }
        try {
            field.setAccessible(true);
            return field.get(object);
        }
        catch (IllegalAccessException e) {
            this.logger.log(Level.SEVERE, "Error", e);
            return null;
        }
    }

    public Type getFieldType(String className, String fieldName) {
        Field field = this.getField(className, fieldName);
        if (field == null) {
            this.logger.log(Level.SEVERE, "Error");
            return null;
        }
        field.setAccessible(true);
        return field.getType();
    }

    public Type getFieldTypeSuperClass(String className, String fieldName) {
        Field field = this.getFieldSuperClass(className, fieldName);
        if (field == null) {
            this.logger.log(Level.SEVERE, "Error");
            return null;
        }
        field.setAccessible(true);
        return field.getType();
    }

    public Object newInstance(String className, List<Object> paramsObjects, boolean accessible, Class<?> ... params) {
        Object object = null;
        try {
            Object[] objs = paramsObjects.toArray();
            Class<?> cls = Class.forName(className);
            Constructor<?> constructor = cls.getDeclaredConstructor(params);
            constructor.setAccessible(accessible);
            object = constructor.newInstance(objs);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return object;
    }

    public Object newInstance(String className, List<Object> paramsObjects, Class<?> ... params) {
        Object object = null;
        try {
            Object[] objs = paramsObjects.toArray();
            Class<?> cls = Class.forName(className);
            Constructor<?> constructor = cls.getDeclaredConstructor(params);
            object = constructor.newInstance(objs);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return object;
    }

    public Object newInstance(String className) {
        Object object = null;
        try {
            Class<?> cls = Class.forName(className);
            Constructor<?> constructor = cls.getDeclaredConstructor(new Class[0]);
            object = constructor.newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return object;
    }

    public Constructor<?>[] getConstructors(String className) {
        Constructor<?>[] object = null;
        try {
            Class<?> cls = Class.forName(className);
            object = cls.getDeclaredConstructors();
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return object;
    }

    public Constructor<?> getConstructor(String className, Class<?> ... params) {
        Constructor<?> object = null;
        try {
            Class<?> cls = Class.forName(className);
            object = cls.getDeclaredConstructor(params);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return object;
    }

    public Constructor<?> getConstructor(String className) {
        Constructor<?> object = null;
        try {
            Class<?> cls = Class.forName(className);
            object = cls.getDeclaredConstructor(new Class[0]);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            this.logger.log(Level.SEVERE, "Error", e);
        }
        return object;
    }

    public Field[] getFields(String className) {
        try {
            Class<?> cls = Class.forName(className);
            return cls.getFields();
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
            return null;
        }
    }

    public Field[] getFieldsSuperClass(String className) {
        try {
            Class<?> cls = Class.forName(className);
            return cls.getSuperclass().getFields();
        }
        catch (ClassNotFoundException e) {
            this.logger.log(Level.SEVERE, "Error", e);
            return null;
        }
    }
}

