/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

import ch.framedev.simplejavautils.Main;
import ch.framedev.simplejavautils.MyFormatter;
import ch.framedev.simplejavautils.SystemUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Base64;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.jetbrains.annotations.NotNull;

public class SimpleJavaUtils {
    public static Logger logger = Logger.getLogger("SimpleJavaUtils");

    public <T extends Serializable> String objectToBase64(T object) {
        try {
            ByteArrayOutputStream is = new ByteArrayOutputStream();
            ObjectOutputStream os = new ObjectOutputStream(is);
            os.writeObject(object);
            os.flush();
            os.close();
            return Base64.getEncoder().encodeToString(is.toByteArray());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error while encoding Object to Base64", e);
            return null;
        }
    }

    public <T> T objectFromBase64(String base) {
        try {
            ByteArrayInputStream is = new ByteArrayInputStream(Base64.getDecoder().decode(base));
            ObjectInputStream os = new ObjectInputStream(is);
            return (T)os.readObject();
        }
        catch (IOException | ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Error while decoding Object from Base64", e);
            return null;
        }
    }

    public <T extends Serializable> void saveObjectToBase64File(File file, T object) {
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(this.objectToBase64(object));
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error while saving Object to Base64 File", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getObjectFromBase64File(File file) {
        T object = null;
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            object = this.objectFromBase64(reader.readLine());
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error while closing Reader", e);
            }
        }
        return object;
    }

    public void debug(Object object) {
        System.out.println(object);
    }

    public void error(Object object) {
        System.err.println(object);
    }

    public Logger createLogger(String name) {
        return Logger.getLogger(name);
    }

    public String[] stringSplitter(String text, @NotNull String regex) {
        if (text == null) {
            return null;
        }
        if (!text.contains(regex)) {
            return null;
        }
        return text.split(regex);
    }

    public Logger createEmptyLogger(String name, boolean timeFormat) {
        return new MyFormatter(timeFormat).createEmptyLogger(name);
    }

    public double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        BigDecimal bd = BigDecimal.valueOf(value);
        bd = bd.setScale(places, RoundingMode.HALF_UP);
        return bd.doubleValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String fileUrl, String location, String fileNameWithExtensions, String newLocation) {
        File file;
        if (location != null) {
            file = new File(location, fileNameWithExtensions);
            if (file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IllegalStateException("Could not create directory : " + file.getParentFile().getAbsolutePath());
            }
        } else {
            file = new File(fileNameWithExtensions);
        }
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            URL url = new URL(fileUrl);
            in = new BufferedInputStream(url.openStream());
            fout = new FileOutputStream(new File(location, fileNameWithExtensions));
            byte[] data = new byte[4096];
            while ((count = in.read(data, 0, 4096)) != -1) {
                fout.write(data, 0, count);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while Downloading File", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error while closing InputStream", e);
            }
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error while closing FileOutputStream", e);
            }
        }
        if (new File(newLocation, fileNameWithExtensions).getParentFile() != null && !new File(newLocation, fileNameWithExtensions).getParentFile().exists() && !new File(newLocation, fileNameWithExtensions).getParentFile().mkdirs()) {
            throw new IllegalStateException("Could not create directory : " + new File(newLocation, fileNameWithExtensions).getParentFile().getAbsolutePath());
        }
        if (!file.renameTo(new File(newLocation, fileNameWithExtensions))) {
            Logger.getLogger("SimpleJavaUtils").log(Level.SEVERE, "File cannot be Renamed or Moved!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void download(String fileUrl, String location, String fileNameWithExtensions) {
        File file;
        if (location != null) {
            file = new File(location, fileNameWithExtensions);
            if (file.getParentFile() != null && !file.getParentFile().exists() && !file.getParentFile().mkdirs()) {
                throw new IllegalStateException("Could not create directory : " + file.getParentFile().getAbsolutePath());
            }
        } else {
            file = new File(fileNameWithExtensions);
        }
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            URL url = new URL(fileUrl);
            in = new BufferedInputStream(url.openStream());
            fout = new FileOutputStream(file);
            byte[] data = new byte[4096];
            while ((count = in.read(data, 0, 4096)) != -1) {
                fout.write(data, 0, count);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while Downloading File", e);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error while closing InputStream", e);
            }
            try {
                if (fout != null) {
                    fout.close();
                }
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error while closing FileOutputStream", e);
            }
        }
    }

    public String getTempDir() {
        String os = System.getProperty("os.name").toLowerCase();
        String tempDir = os.contains("mac") ? System.getProperty("java.io.tmpdir") + "/" : (os.contains("windows") ? System.getProperty("java.io.tmpdir") + "/" : System.getProperty("java.io.tmpdir") + "/");
        return tempDir;
    }

    public String getUserHome() {
        String os = System.getProperty("os.name").toLowerCase();
        String userDir = os.contains("mac") ? System.getProperty("user.home") : (os.contains("windows") ? System.getProperty("user.home") + "/" : System.getProperty("user.home") + "/");
        return userDir;
    }

    public String getUserDir() {
        String os = System.getProperty("os.name").toLowerCase();
        String userDir = os.contains("mac") ? System.getProperty("user.dir") + "/" : (os.contains("windows") ? System.getProperty("user.dir") + "/" : System.getProperty("user.dir") + "/");
        return userDir;
    }

    public String getUserAppData() {
        String os = this.getOs();
        String userData = os.contains("mac") ? System.getProperty("user.home") + "/Library/Application Support/" : (os.contains("windows") ? System.getenv("APPDATA") + "/" : System.getProperty("user.home") + "/");
        return userData;
    }

    public String getOs() {
        return System.getProperty("os.name").toLowerCase();
    }

    public String getOsVersion() {
        return System.getProperty("os.version").toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File streamToFile(InputStream in) {
        if (in == null) {
            return null;
        }
        FileOutputStream out = null;
        try {
            int bytesRead;
            File f = File.createTempFile(String.valueOf(in.hashCode()), ".tmp");
            f.deleteOnExit();
            out = new FileOutputStream(f);
            byte[] buffer = new byte[1024];
            while ((bytesRead = in.read(buffer)) != -1) {
                out.write(buffer, 0, bytesRead);
            }
            File file = f;
            return file;
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error while creating Temp File", e);
            File file = null;
            return file;
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    logger.log(Level.SEVERE, "Error while closing FileOutputStream", e);
                }
            }
        }
    }

    public File getFromResourceFile(String file) {
        InputStream resource = this.getClass().getClassLoader().getResourceAsStream(file);
        if (resource == null) {
            throw new IllegalArgumentException("File not found!");
        }
        return this.streamToFile(resource);
    }

    public File getFromResourceFile(String file, Class<?> class_) {
        InputStream resource = class_.getClassLoader().getResourceAsStream(file);
        if (resource == null) {
            throw new IllegalArgumentException("File not found!");
        }
        return this.streamToFile(resource);
    }

    public boolean existsFile(String fileName) {
        return new File(fileName).exists();
    }

    public boolean existsFile(File file) {
        if (file == null) {
            return false;
        }
        return file.exists();
    }

    public void copyFileTo(File source, File target) throws IOException {
        Files.copy(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public void moveFileTo(File source, File target) throws IOException {
        Files.move(source.toPath(), target.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public File zipDirectory(File directory, File outPut) throws IOException {
        FileOutputStream fos = new FileOutputStream(outPut);
        ZipOutputStream zipOut = new ZipOutputStream(fos);
        this.zipFile(directory, directory.getName(), zipOut);
        zipOut.close();
        fos.close();
        return outPut;
    }

    public File zipFiles(File zipFile, File ... files) throws IOException {
        FileOutputStream fos = new FileOutputStream(zipFile);
        ZipOutputStream zipOut = new ZipOutputStream(fos);
        for (File srcFile : files) {
            int length;
            FileInputStream fis = new FileInputStream(srcFile);
            ZipEntry zipEntry = new ZipEntry(srcFile.getName());
            zipOut.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zipOut.write(bytes, 0, length);
            }
            fis.close();
        }
        zipOut.close();
        fos.close();
        return zipFile;
    }

    private void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut) throws IOException {
        int length;
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            if (fileName.endsWith("/")) {
                zipOut.putNextEntry(new ZipEntry(fileName));
                zipOut.closeEntry();
            } else {
                zipOut.putNextEntry(new ZipEntry(fileName + "/"));
                zipOut.closeEntry();
            }
            File[] children = fileToZip.listFiles();
            if (children == null) {
                throw new IOException("Error while zipping File : " + fileToZip.getName());
            }
            for (File childFile : children) {
                this.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut);
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }

    public static boolean isOnline(String server, int port, int timeout) {
        boolean b = true;
        try {
            InetSocketAddress sa = new InetSocketAddress(server, port);
            Socket ss = new Socket();
            ss.connect(sa, timeout);
            ss.close();
        }
        catch (Exception e) {
            b = false;
        }
        return b;
    }

    public boolean isOnline(String server, int port) {
        return SimpleJavaUtils.isOnline(server, port, 2500);
    }

    public Logger getLogger() {
        return this.createEmptyLogger("SimpleJavaUtils", true);
    }

    public String getFilePath() {
        try {
            if (new SystemUtils().getOSType() == SystemUtils.OSType.WINDOWS) {
                return new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getPath() + "\\";
            }
            return new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getPath() + "/";
        }
        catch (URISyntaxException e) {
            this.getLogger().log(Level.SEVERE, "Error while getting File Path", e);
            throw new RuntimeException(e);
        }
    }

    public String getFilePath(Class<?> clazz) {
        try {
            if (new SystemUtils().getOSType() == SystemUtils.OSType.WINDOWS) {
                return new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getPath() + "\\";
            }
            return new File(clazz.getProtectionDomain().getCodeSource().getLocation().toURI()).getParentFile().getPath() + "/";
        }
        catch (URISyntaxException e) {
            this.getLogger().log(Level.SEVERE, "Error while getting File Path", e);
            throw new RuntimeException(e);
        }
    }

    public byte[] encodeFileToBase64BinaryArray(File file) {
        byte[] byArray;
        FileInputStream fileInputStreamReader = new FileInputStream(file);
        try {
            byte[] bytes = new byte[(int)file.length()];
            fileInputStreamReader.read(bytes);
            byArray = Base64.getEncoder().encode(bytes);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileInputStreamReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Error while encoding File to Base64", e);
                return null;
            }
        }
        fileInputStreamReader.close();
        return byArray;
    }

    public File decodeFileFromBase64Binary(byte[] decodedFile, String extension, String fileName, String location) {
        File newFileName = null;
        try {
            newFileName = extension == null ? new File(location, fileName) : File.createTempFile(location, fileName + "." + extension);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Error while creating new File", ex);
        }
        try {
            byte[] decodedBytes = Base64.getDecoder().decode(decodedFile);
            if (newFileName != null) {
                FileOutputStream fos = new FileOutputStream(newFileName);
                fos.write(decodedBytes);
                fos.close();
                System.out.println("Decoding completed. File saved as " + newFileName);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error while decoding File from Base64", e);
        }
        return newFileName;
    }

    public File decodeFileFromBase64BinaryTmp(byte[] decodedFile, String extension) {
        File file;
        try {
            file = extension != null ? File.createTempFile("simplejavautils", "." + extension) : File.createTempFile("simplejavautils", "");
            try {
                byte[] decodedBytes = Base64.getDecoder().decode(decodedFile);
                FileOutputStream fos = new FileOutputStream(file);
                fos.write(decodedBytes);
                fos.close();
                System.out.println("Decoding completed. File saved as " + file.toPath());
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Error while decoding File from Base64", e);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        file.deleteOnExit();
        return file;
    }

    public String capitalizeFirstLetter(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public String capitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toUpperCase() + str.substring(1);
    }

    public String uncapitalize(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    public String toCamelCase(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        String[] parts = str.split(" ");
        StringBuilder camelCaseString = new StringBuilder();
        for (String part : parts) {
            camelCaseString.append(this.capitalize(part));
        }
        return camelCaseString.toString();
    }

    public String toPascalCase(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        String[] parts = str.split(" ");
        StringBuilder pascalCaseString = new StringBuilder();
        for (String part : parts) {
            pascalCaseString.append(this.capitalize(part));
        }
        return pascalCaseString.toString();
    }

    public String toSnakeCase(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase();
    }

    public String toKebabCase(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        return str.replaceAll("([a-z])([A-Z])", "$1-$2").toLowerCase();
    }

    public String toTitleCase(String str) {
        if (str == null || str.isEmpty()) {
            return str;
        }
        String[] parts = str.split(" ");
        StringBuilder titleCaseString = new StringBuilder();
        for (String part : parts) {
            titleCaseString.append(this.capitalize(part)).append(" ");
        }
        return titleCaseString.toString().trim();
    }
}

