/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

public enum Time {
    SECONDS(1L),
    MINUTES(60L),
    HOURS(3600L),
    DAYS(86400L),
    WEEKS(604800L),
    MONTHS(2628000L),
    YEARS(31536000L);

    private final long seconds;

    private Time(long seconds) {
        this.seconds = seconds;
    }

    public long getSeconds() {
        return this.seconds;
    }

    public static double convert(long value, Time from, Time to) {
        return (double)value * (double)from.seconds / (double)to.seconds;
    }

    public double convertTo(long value, Time to) {
        return Time.convert(value, this, to);
    }

    public String toString() {
        return this.name() + " (" + this.seconds + " seconds)";
    }
}

