/*
 * Decompiled with CFR 0.152.
 */
package ch.framedev.simplejavautils;

import ch.framedev.simplejavautils.SimpleJavaUtils;
import java.io.Serializable;

public class Cooldown
implements Serializable {
    private final int id;
    private final int seconds;
    private long secondsLeft;
    private long milliSecondsLeft;
    private long milliSeconds;
    private final long actualTime;

    public Cooldown(int id, int seconds, long actualTime) {
        this.id = id;
        this.seconds = seconds;
        this.actualTime = actualTime;
    }

    public Cooldown(int id, int seconds) {
        this.id = id;
        this.seconds = seconds;
        this.actualTime = System.currentTimeMillis();
    }

    public Cooldown() {
        this.id = 0;
        this.seconds = 0;
        this.actualTime = 0L;
    }

    public long getSecondsLeft() {
        return this.secondsLeft;
    }

    public long getMilliSecondsLeft() {
        return this.secondsLeft * 1000L;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public long getMilliSeconds() {
        return this.milliSeconds;
    }

    public int getId() {
        return this.id;
    }

    public boolean check() {
        this.secondsLeft = this.actualTime / 1000L + (long)this.seconds - System.currentTimeMillis() / 1000L;
        this.milliSeconds = this.actualTime + (long)this.seconds * 1000L - System.currentTimeMillis();
        return this.secondsLeft <= 0L;
    }

    public boolean isExpired() {
        return this.check();
    }

    public void sendInformation() {
        new SimpleJavaUtils().getLogger().info("ID : " + this.id);
        new SimpleJavaUtils().getLogger().info("Seconds Left : " + this.secondsLeft);
        new SimpleJavaUtils().getLogger().info("Is Expired : " + this.isExpired());
    }

    public String toString() {
        return "Cooldown{id=" + this.id + ", seconds=" + this.seconds + ", secondsLeft=" + this.secondsLeft + ", milliSecondsLeft=" + this.milliSecondsLeft + ", milliSeconds=" + this.milliSeconds + ", actualTime=" + this.actualTime + '}';
    }
}

