package io.github.gajendragusain.httpserver.embeddedserver;

import io.github.gajendragusain.httpserver.annotations.DELETE;
import io.github.gajendragusain.httpserver.annotations.GET;
import io.github.gajendragusain.httpserver.annotations.POST;
import io.github.gajendragusain.httpserver.annotations.PUT;
import io.github.gajendragusain.httpserver.parseutils.N_aryNode;
import io.github.gajendragusain.httpserver.parseutils.URLPatternProcessor;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;


public class Configuration {
    public static class HTTPMethod {
        public static final String METHOD_GET = "GET";
        public static final String METHOD_POST = "POST";
        public static final String METHOD_PUT = "PUT";
        public static final String METHOD_DELETE = "DELETE";
    }

    private static final String TAG = "RouterConfig";
    private final Map<String, Map<String, RequestConfig>> methodRequestMap = new HashMap<>();
    private final Set<Controller> controllers = new HashSet<>();

    private final int DEFAULT_MAX_EVENT_EXECUTOR_THREADS = 2;
    private int maxEventExecutorsThreads = DEFAULT_MAX_EVENT_EXECUTOR_THREADS;

    protected int getMaxEventExecutorsThreads() {
        return maxEventExecutorsThreads;
    }

    protected void setMaxEventExecutorsThreads(int maxEventExecutorsThreads) {
        this.maxEventExecutorsThreads = maxEventExecutorsThreads;
    }

    protected Configuration() {
    }

    protected void add(Controller controller) {
        controllers.add(controller);
    }

    public Map<String, Map<String, RequestConfig>> getMethodRequestMap() {
        return methodRequestMap;
    }

    private URLPatternProcessor getParseTree(String str) {
        URLPatternProcessor URLPatternProcessor = new URLPatternProcessor(str);
        return URLPatternProcessor;
    }

    protected void configure() {
        for (Controller a : controllers) {
            Method[] methods = a.getClass().getMethods();
            for (Method m : methods) {
                if (m.isAnnotationPresent(GET.class)) {
                    GET get = m.getAnnotation(GET.class);
                    String regex = getRegexFromURLPattern(get.value());
                    RequestConfig requestConfig = new RequestConfig(HTTPMethod.METHOD_GET, get.value(), regex, "", get.responseType(), m, a);
                    String hashKey = requestConfig.hashKey;
                    System.out.println("----------hashkey: " + hashKey);
//                    stringRequestConfigMap.put(hashKey, requestConfig);
                    mapMethodToRequest(HTTPMethod.METHOD_GET, hashKey, requestConfig);
                } else if (m.isAnnotationPresent(POST.class)) {
                    POST post = m.getAnnotation(POST.class);
                    String regex = getRegexFromURLPattern(post.value());
                    RequestConfig requestConfig = new RequestConfig(HTTPMethod.METHOD_POST, post.value(), regex, post.contentType(), post.responseType(), m, a);
                    String hashKey = requestConfig.hashKey;
                    System.out.println("----------hashkey: " + hashKey);
//                    stringRequestConfigMap.put(hashKey, requestConfig);
                    mapMethodToRequest(HTTPMethod.METHOD_POST, hashKey, requestConfig);
                } else if (m.isAnnotationPresent(PUT.class)) {
                    PUT put = m.getAnnotation(PUT.class);
                } else if (m.isAnnotationPresent(DELETE.class)) {
                    DELETE delete = m.getAnnotation(DELETE.class);
                }
            }
        }
        System.out.println(methodRequestMap.toString());
    }

    private void mapMethodToRequest(String method, String hashKey, RequestConfig requestConfig) {
        Map<String, RequestConfig> stringRequestConfigMap = methodRequestMap.get(method);
        if (stringRequestConfigMap == null) {
            stringRequestConfigMap = new HashMap<>();
            methodRequestMap.put(method, stringRequestConfigMap);
        }
        stringRequestConfigMap.put(hashKey, requestConfig);
    }

    private String getRegexFromURLPattern(String urlPattern) {
        URLPatternProcessor URLPatternProcessor = getParseTree(urlPattern);
        N_aryNode<String> node = URLPatternProcessor.buildAST();
        // convert urlPattern to regular expression
        String regex = URLPatternProcessor.convertASTtoREGEX();
        return regex.trim();
    }

    protected static class RequestConfig {
        protected String hashKey;
        protected String urlPattern;
        protected String urlRegex;
        protected String httpMethod;
        protected String contentType;
        protected String responseType;
        protected Method handlerMethod;
        protected Controller controller;

        protected RequestConfig(String method, String urlPattern, String urlRegex, String contentType, String responseType, Method handlerMethod, Controller controller) {
            this.hashKey = method + "|" + urlPattern + "|" + contentType;
            this.httpMethod = method;
            this.urlPattern = urlPattern;
            this.urlRegex = urlRegex;
            this.contentType = contentType;
            this.responseType = responseType;
            this.handlerMethod = handlerMethod;
            this.controller = controller;
        }

        @Override
        public String toString() {
            return "RequestConfig{" +
                    "config='" + hashKey + '\'' +
                    ", urlPattern='" + urlPattern + '\'' +
                    ", urlRegex='" + urlRegex + '\'' +
                    ", httpMethod='" + httpMethod + '\'' +
                    ", contentType='" + contentType + '\'' +
                    ", responseType='" + responseType + '\'' +
                    ", handlerMethod=" + handlerMethod +
                    '}';
        }
    }
}


