package io.github.gajendragusain.httpserver.parseutils;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class URLPatternProcessor {
    public static final String PLACEHOLDER_REGEX = "/[a-zA-Z0-9]+?";
    private N_aryNode<String> root = null;
    private Set<String> symbols;
    private final Map<String, String> symbolMap = new HashMap<>();

    private String urlPattern;

    public URLPatternProcessor(Set<String> symbols) {
        this.symbols = symbols;
    }

    public URLPatternProcessor(String urlPattern) {
        this.urlPattern = urlPattern;
        symbols = new HashSet<>();
        Pattern patternClass = Pattern.compile("\\{.+?\\}");
        Matcher matcher = patternClass.matcher(urlPattern);
        while (matcher.find()) {
            symbols.add(matcher.group());
        }
    }

    private N_aryNode<String> buildAST(String[] tokens) {
        Stack<N_aryNode<String>> stack = new Stack<>();
        List<N_aryNode<String>> currentLNodes = new ArrayList<>();
        for (String s : tokens) {
            if (s.trim().isEmpty())
                continue;
            if (!stack.empty() && !symbols.contains(s)) {
                root = stack.peek();
                if (root.rNodes == null)
                    root.rNodes = new ArrayList<>();
                root.rNodes.add(new N_aryNode<>(s));
                continue;
            }
            if (symbols.contains(s)) {
                if (!stack.empty()) {
                    root = stack.pop();
                    currentLNodes.add(root);
                }
                root = new N_aryNode<>(s);
                root.lNodes = new ArrayList<>(currentLNodes);
                stack.push(root);
                currentLNodes = new ArrayList<>();
                continue;
            }
            currentLNodes.add(new N_aryNode<>(s));
        }

        return root;
    }

    public N_aryNode<String> buildAST() {
        return buildAST(urlPattern.split("/"));
    }

    public String convertASTtoREGEX() {
        StringBuilder regexBuilder = new StringBuilder();
        if (!symbols.isEmpty())
            convertASTtoREGEX(root, regexBuilder);
        return regexBuilder.toString();
    }

    private void convertASTtoREGEX(N_aryNode<String> node, StringBuilder buf) {
        if (node == null) {
            return;
        }
        if (node.lNodes != null) {
            for (N_aryNode<String> n : node.lNodes) {
                convertASTtoREGEX(n, buf);
            }
        }
        /*if(node.val.equals("{id}")) {
            buf.append("/[0-9]+");
        } else {
            buf.append("/" + node.val);
        }*/
        if (symbols.contains(node.val)) {
            buf.append(PLACEHOLDER_REGEX);
            symbolMap.put(node.val, PLACEHOLDER_REGEX);
        } else {
            buf.append("/" + node.val);
        }
        if (node.rNodes != null) {
            for (N_aryNode<String> n : node.rNodes) {
                convertASTtoREGEX(n, buf);
            }
        }
    }

/*    public void annotationValTree(N_aryNode<String> node, StringBuilder buf) {
        if(node==null) {
            return;
        }
        if(node.lNodes !=null) {
            for(N_aryNode<String> n: node.lNodes) {
                convertASTtoREGEX(n, buf);
            }
        }
        if(node.val.equals("{id}")) {
            buf.append("/id");
        } else {
            buf.append("/" + node.val);
        }
        if(node.rNodes !=null) {
            for(N_aryNode<String> n: node.rNodes) {
                convertASTtoREGEX(n,buf);
            }
        }
    }*/
}
