/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.processor.retrievers;

import graphql.annotations.processor.ProcessingElementsContainer;
import graphql.annotations.processor.exceptions.CannotCastMemberException;
import graphql.annotations.processor.exceptions.GraphQLAnnotationsException;
import graphql.annotations.processor.retrievers.GraphQLTypeRetriever;
import graphql.schema.GraphQLOutputType;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={GraphQLObjectHandler.class}, immediate=true)
public class GraphQLObjectHandler {
    private GraphQLTypeRetriever typeRetriever;

    public <T extends GraphQLOutputType> T getGraphQLType(Class<?> object, ProcessingElementsContainer container) throws GraphQLAnnotationsException, CannotCastMemberException {
        GraphQLOutputType type = (GraphQLOutputType)this.typeRetriever.getGraphQLType(object, container, false);
        try {
            return (T)type;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Cannot cast type " + type.getClass().getSimpleName());
        }
    }

    public GraphQLTypeRetriever getTypeRetriever() {
        return this.typeRetriever;
    }

    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    public void setTypeRetriever(GraphQLTypeRetriever typeRetriever) {
        this.typeRetriever = typeRetriever;
    }

    public void unsetTypeRetriever(GraphQLTypeRetriever typeRetriever) {
        this.typeRetriever = null;
    }
}

