/*
 * Decompiled with CFR 0.152.
 */
package graphql.annotations.directives;

import graphql.annotations.directives.AnnotationsDirectiveWiring;
import graphql.annotations.directives.AnnotationsWiringEnvironment;
import graphql.annotations.directives.AnnotationsWiringEnvironmentImpl;
import graphql.annotations.directives.InvalidDirectiveLocationException;
import graphql.annotations.directives.TreeTransformerUtilWrapper;
import graphql.introspection.Introspection;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLDirectiveContainer;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLEnumValueDefinition;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchemaElement;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.GraphQLTypeVisitor;
import graphql.schema.GraphQLUnionType;
import graphql.util.TraversalControl;
import graphql.util.TraverserContext;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DirectiveSchemaVisitor
implements GraphQLTypeVisitor {
    private HashMap<String, AnnotationsDirectiveWiring> directiveWiringMap;
    private GraphQLCodeRegistry.Builder codeRegistryBuilder;
    private TreeTransformerUtilWrapper transformerUtilWrapper;
    private Map<Class, WiringFunction> functionMap;

    public DirectiveSchemaVisitor(HashMap<String, AnnotationsDirectiveWiring> directiveWiringMap, GraphQLCodeRegistry.Builder codeRegistryBuilder, TreeTransformerUtilWrapper treeTransformerUtilWrapper) {
        this.directiveWiringMap = directiveWiringMap;
        this.functionMap = this.createFunctionsMap();
        this.codeRegistryBuilder = codeRegistryBuilder;
        this.transformerUtilWrapper = treeTransformerUtilWrapper;
    }

    public TraversalControl visitGraphQLArgument(GraphQLArgument node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitGraphQLType(GraphQLArgument.class, (GraphQLDirectiveContainer)node, context);
    }

    public TraversalControl visitGraphQLInterfaceType(GraphQLInterfaceType node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitGraphQLType(GraphQLInterfaceType.class, (GraphQLDirectiveContainer)node, context);
    }

    public TraversalControl visitGraphQLEnumType(GraphQLEnumType node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitGraphQLType(GraphQLEnumType.class, (GraphQLDirectiveContainer)node, context);
    }

    public TraversalControl visitGraphQLEnumValueDefinition(GraphQLEnumValueDefinition node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitGraphQLType(GraphQLEnumValueDefinition.class, (GraphQLDirectiveContainer)node, context);
    }

    public TraversalControl visitGraphQLFieldDefinition(GraphQLFieldDefinition node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitGraphQLType(GraphQLFieldDefinition.class, (GraphQLDirectiveContainer)node, context);
    }

    public TraversalControl visitGraphQLDirective(GraphQLDirective node, TraverserContext<GraphQLSchemaElement> context) {
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visitGraphQLInputObjectField(GraphQLInputObjectField node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitGraphQLType(GraphQLInputObjectField.class, (GraphQLDirectiveContainer)node, context);
    }

    public TraversalControl visitGraphQLInputObjectType(GraphQLInputObjectType node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitGraphQLType(GraphQLInputObjectType.class, (GraphQLDirectiveContainer)node, context);
    }

    public TraversalControl visitGraphQLList(GraphQLList node, TraverserContext<GraphQLSchemaElement> context) {
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visitGraphQLNonNull(GraphQLNonNull node, TraverserContext<GraphQLSchemaElement> context) {
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visitGraphQLObjectType(GraphQLObjectType node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitGraphQLType(GraphQLObjectType.class, (GraphQLDirectiveContainer)node, context);
    }

    public TraversalControl visitGraphQLScalarType(GraphQLScalarType node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitGraphQLType(GraphQLScalarType.class, (GraphQLDirectiveContainer)node, context);
    }

    public TraversalControl visitGraphQLTypeReference(GraphQLTypeReference node, TraverserContext<GraphQLSchemaElement> context) {
        return TraversalControl.CONTINUE;
    }

    public TraversalControl visitGraphQLUnionType(GraphQLUnionType node, TraverserContext<GraphQLSchemaElement> context) {
        return this.visitGraphQLType(GraphQLUnionType.class, (GraphQLDirectiveContainer)node, context);
    }

    private TraversalControl visitGraphQLType(Class<? extends GraphQLDirectiveContainer> typeOfContainer, GraphQLDirectiveContainer node, TraverserContext<GraphQLSchemaElement> context) {
        List directives = node.getDirectives();
        if (directives.size() == 0) {
            return TraversalControl.CONTINUE;
        }
        GraphQLDirectiveContainer newNode = node;
        for (GraphQLDirective directive : directives) {
            AnnotationsDirectiveWiring wiring = this.directiveWiringMap.get(directive.getName());
            if (wiring == null) continue;
            try {
                GraphQLSchemaElement parentElement = (GraphQLSchemaElement)context.getParentNode();
                newNode = this.functionMap.get(typeOfContainer).apply(directive, newNode, wiring, parentElement);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.transformerUtilWrapper.changeNode(context, newNode);
    }

    private void putInMap(Map<Class, WiringFunction> map, Class clazz, String functionName, Introspection.DirectiveLocation ... locations) {
        map.put(clazz, (d, e, wiring, parentElement) -> {
            this.assertLocation(d, e, locations);
            AnnotationsWiringEnvironmentImpl environment = new AnnotationsWiringEnvironmentImpl(e, e.getDirective(d.getName()), parentElement, this.codeRegistryBuilder);
            return (GraphQLDirectiveContainer)wiring.getClass().getMethod(functionName, AnnotationsWiringEnvironment.class).invoke((Object)wiring, environment);
        });
    }

    private Map<Class, WiringFunction> createFunctionsMap() {
        HashMap<Class, WiringFunction> functionMap = new HashMap<Class, WiringFunction>();
        this.putInMap(functionMap, GraphQLFieldDefinition.class, "onField", Introspection.DirectiveLocation.FIELD, Introspection.DirectiveLocation.FIELD_DEFINITION);
        this.putInMap(functionMap, GraphQLObjectType.class, "onObject", Introspection.DirectiveLocation.OBJECT);
        this.putInMap(functionMap, GraphQLArgument.class, "onArgument", Introspection.DirectiveLocation.ARGUMENT_DEFINITION);
        this.putInMap(functionMap, GraphQLInterfaceType.class, "onInterface", Introspection.DirectiveLocation.INTERFACE);
        this.putInMap(functionMap, GraphQLUnionType.class, "onUnion", Introspection.DirectiveLocation.UNION);
        this.putInMap(functionMap, GraphQLEnumType.class, "onEnum", Introspection.DirectiveLocation.ENUM);
        this.putInMap(functionMap, GraphQLEnumValueDefinition.class, "onEnumValue", Introspection.DirectiveLocation.ENUM_VALUE);
        this.putInMap(functionMap, GraphQLScalarType.class, "onScalar", Introspection.DirectiveLocation.SCALAR);
        this.putInMap(functionMap, GraphQLInputObjectType.class, "onInputObjectType", Introspection.DirectiveLocation.INPUT_OBJECT);
        this.putInMap(functionMap, GraphQLInputObjectField.class, "onInputObjectField", Introspection.DirectiveLocation.INPUT_FIELD_DEFINITION);
        return functionMap;
    }

    private void assertLocation(GraphQLDirective graphQLDirective, GraphQLDirectiveContainer element, Introspection.DirectiveLocation ... validLocations) {
        boolean isSupported = false;
        for (Introspection.DirectiveLocation validLocation : validLocations) {
            if (!graphQLDirective.validLocations().contains(validLocation)) continue;
            isSupported = true;
        }
        if (!isSupported) {
            throw this.getInvalidDirectiveLocationException(element, graphQLDirective, validLocations);
        }
    }

    private InvalidDirectiveLocationException getInvalidDirectiveLocationException(GraphQLDirectiveContainer element, GraphQLDirective graphQLDirective, Introspection.DirectiveLocation ... validLocations) {
        return new InvalidDirectiveLocationException("The element: '" + element.getName() + "' is annotated with the directive: '" + graphQLDirective.getName() + "' which is not valid on the element location: '" + Arrays.toString(Arrays.stream(validLocations).map(Enum::name).toArray()) + "'", null);
    }

    @FunctionalInterface
    static interface WiringFunction {
        public GraphQLDirectiveContainer apply(GraphQLDirective var1, GraphQLDirectiveContainer var2, AnnotationsDirectiveWiring var3, GraphQLSchemaElement var4) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException;
    }
}

