/*
 * Decompiled with CFR 0.152.
 */
package haigh.api.nlu;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import haigh.api.nlu.model.FilteringCondition;
import haigh.api.nlu.model.InformationCenter;
import haigh.api.nlu.model.RegisterCourse;
import haigh.api.nlu.model.RegistrationResults;
import haigh.api.nlu.model.Student;
import haigh.api.nlu.util.APIUtil;
import haigh.api.nlu.util.ConstantUtil;
import haigh.api.nlu.util.ListTypeUtil;
import haigh.api.nlu.util.ProcessUtil;
import java.io.IOException;
import java.util.List;
import okhttp3.Headers;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class API {
    private static OkHttpClient client = new OkHttpClient();
    private Gson gson;
    private static Headers headersGeneral;
    private static Headers headers;
    private ConstantUtil constantUtil = ConstantUtil.instance;
    private static ProcessUtil processUtil;

    public API() {
        headersGeneral = new Headers.Builder().add("user-agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/131.0.0.0 Safari/537.36").build();
        this.gson = new Gson();
    }

    private String getUA(String apiParam) {
        return ProcessUtil.gc(ProcessUtil.isapi(APIUtil.requestWithAPI(apiParam)));
    }

    public RegisterCourse dkmh(String authorization, String id_to_hoc, boolean isDK) throws IOException {
        String apiParam = this.constantUtil.getXuLydkmhSinhVien();
        this.setHeadersUA(apiParam, authorization);
        String params = "{\"filter\": {\"id_to_hoc\": " + id_to_hoc + ", \"is_checked\": " + isDK + ", \"sv_nganh\": 1}}";
        Response response = API.request("POST", APIUtil.requestWithAPIUrlPublic(apiParam), headers, params);
        if (response.isSuccessful()) {
            return (RegisterCourse)this.gson.fromJson((JsonElement)((JsonObject)this.gson.fromJson(response.body().string(), JsonObject.class)).getAsJsonObject("data"), RegisterCourse.class);
        }
        return null;
    }

    public InformationCenter dsThongTin(String authorization) throws IOException {
        String apiParam = this.constantUtil.getLocDsNhomTo();
        this.setHeadersUA(apiParam, authorization);
        String params = " {\"is_CVHT\": false,\"additional\": {\"paging\": {\"limit\": 99999, \"page\": 1}, \"ordering\": [{\"name\": \"\", \"order_type\": \"\"}]}\n}";
        Response response = API.request("POST", APIUtil.requestWithAPIUrlPublic(apiParam), headers, params);
        if (response.isSuccessful()) {
            return (InformationCenter)this.gson.fromJson((JsonElement)((JsonObject)this.gson.fromJson(response.body().string(), JsonObject.class)).getAsJsonObject("data"), InformationCenter.class);
        }
        return null;
    }

    public List<RegistrationResults> dsKetQuaDKMH(String authorization) throws IOException {
        String apiParam = this.constantUtil.getLocDsKQdkmhSinhVien();
        this.setHeadersUA(apiParam, authorization);
        String params = " {\"is_CVHT\": false, \"is_Clear\": false}";
        Response response = API.request("POST", APIUtil.requestWithAPIUrlPublic(apiParam), headers, params);
        if (response.isSuccessful()) {
            JsonObject jsonObject = (JsonObject)this.gson.fromJson(response.body().string(), JsonObject.class);
            return (List)this.gson.fromJson(jsonObject.getAsJsonObject("data").getAsJsonArray("ds_kqdkmh").toString(), ListTypeUtil.dsKetQuaDKMH);
        }
        return null;
    }

    public List<FilteringCondition> dsDKLoc(String authorization) throws IOException {
        String apiParam = this.constantUtil.getLocDsDieuKienLoc();
        this.setHeadersUA(apiParam, authorization);
        Response response = API.request("POST", APIUtil.requestWithAPIUrl(apiParam), headers, null);
        if (response.isSuccessful()) {
            return (List)this.gson.fromJson(response.body().string(), ListTypeUtil.dsDKLocType);
        }
        return null;
    }

    public Student login(String username, String password) throws IOException {
        headers = headersGeneral.newBuilder().add("ua", this.getUA(this.constantUtil.getLogin())).build();
        String params = "username=" + username + "&password=" + password + "&grant_type=password";
        Response response = API.request("POST", APIUtil.requestWithAPIUrl(this.constantUtil.getLogin()), headers, params);
        if (response.isSuccessful()) {
            return (Student)this.gson.fromJson(response.body().string(), Student.class);
        }
        return null;
    }

    private void setHeadersUA(String apiParam, String authorization) {
        headers = headersGeneral.newBuilder().add("ua", this.getUA(apiParam)).add("authorization", authorization).build();
    }

    private static Response request(String method, String url, Headers headers, String params) throws IOException {
        Request.Builder builder = new Request.Builder().url(url).headers(headers);
        if (!method.equalsIgnoreCase("GET")) {
            RequestBody body = params != null ? RequestBody.create((String)params, (MediaType)MediaType.parse((String)"application/json; charset=utf-8")) : RequestBody.create((String)"", (MediaType)MediaType.parse((String)"application/json"));
            builder = builder.method(method, body);
        }
        Request request = builder.build();
        return client.newCall(request).execute();
    }

    static {
        processUtil = ProcessUtil.instance;
    }
}

