/*
 * Decompiled with CFR 0.152.
 */
package haigh.api.nlu;

import com.google.gson.Gson;
import haigh.api.nlu.API;
import haigh.api.nlu.model.FilteringCondition;
import haigh.api.nlu.model.Group;
import haigh.api.nlu.model.InformationCenter;
import haigh.api.nlu.model.RegisterCourse;
import haigh.api.nlu.model.RegistrationResults;
import haigh.api.nlu.model.Student;
import haigh.api.nlu.model.Subject;
import haigh.api.nlu.util.ConstantUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class Test {
    static API api;

    public static void main(String[] args) throws Exception {
        api = new API();
        Account myAccount = Test.readAccountJSON();
        Student sinh_vien = api.login(myAccount.username, myAccount.password);
        List<FilteringCondition> dsDKLoc = api.dsDKLoc(sinh_vien.getAuthorization());
        List<RegistrationResults> dsKetQuaDKMH = api.dsKetQuaDKMH(sinh_vien.getAuthorization());
        System.out.println(dsKetQuaDKMH);
        InformationCenter informationCenter = api.dsThongTin(sinh_vien.getAuthorization());
        List<Subject> dsMonHoc = informationCenter.getDs_mon_hoc();
        List<Group> dsNhomTo = informationCenter.getDs_nhom_to();
    }

    private static void dkmh(Group nhom_to, String authorization, boolean isDK) throws IOException {
        String idMonHoc = nhom_to.getId_mon();
        RegisterCourse ketQuaDangKi = api.dkmh(authorization, idMonHoc, isDK);
        if (ketQuaDangKi.isIs_thanh_cong()) {
            System.out.println("Th\u1ef1c hi\u1ec7n th\u00e0nh c\u00f4ng");
        } else {
            System.out.println("L\u1ed7i: " + ketQuaDangKi.getThong_bao_loi());
        }
    }

    private static List<Group> findGroupBySubjectID(String maMonHoc, String tenMonHoc, List<Group> dsNhomTo) {
        ArrayList<Group> groups = new ArrayList<Group>();
        for (Group group : dsNhomTo) {
            String maMonG = group.getMa_mon();
            if (!maMonG.equalsIgnoreCase(maMonHoc)) continue;
            if (tenMonHoc != null) {
                group.setTen_mon(tenMonHoc);
            }
            groups.add(group);
        }
        return groups;
    }

    private static String findIdSubject(String tenMonHoc, List<Subject> subjects) {
        for (Subject monHoc : subjects) {
            if (!monHoc.getTen().equalsIgnoreCase(tenMonHoc)) continue;
            return monHoc.getMa();
        }
        return "";
    }

    private static Account readAccountJSON() {
        InputStream inputStream = ConstantUtil.class.getClassLoader().getResourceAsStream("account.json");
        if (inputStream != null) {
            String json = "";
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    json = json + line;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Gson gson = new Gson();
            return (Account)gson.fromJson(json, Account.class);
        }
        return null;
    }

    class Account {
        public String username;
        public String password;

        Account() {
        }
    }
}

