/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.request.resource.impl;

import io.github.ibuildthecloud.gdapi.condition.Condition;
import io.github.ibuildthecloud.gdapi.context.ApiContext;
import io.github.ibuildthecloud.gdapi.factory.SchemaFactory;
import io.github.ibuildthecloud.gdapi.id.IdFormatter;
import io.github.ibuildthecloud.gdapi.model.Action;
import io.github.ibuildthecloud.gdapi.model.Collection;
import io.github.ibuildthecloud.gdapi.model.ListOptions;
import io.github.ibuildthecloud.gdapi.model.Resource;
import io.github.ibuildthecloud.gdapi.model.Schema;
import io.github.ibuildthecloud.gdapi.model.impl.CollectionImpl;
import io.github.ibuildthecloud.gdapi.model.impl.WrappedResource;
import io.github.ibuildthecloud.gdapi.request.ApiRequest;
import io.github.ibuildthecloud.gdapi.request.resource.ResourceManager;
import io.github.ibuildthecloud.gdapi.request.resource.ResourceManagerLocator;
import io.github.ibuildthecloud.gdapi.util.RequestUtils;
import io.github.ibuildthecloud.model.Pagination;
import io.github.ibuildthecloud.url.UrlBuilder;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractBaseResourceManager
implements ResourceManager {
    Map<String, Map<String, String>> linksCache = Collections.synchronizedMap(new WeakHashMap());
    Set<Class<?>> resourcesToCreate = new HashSet();
    protected ResourceManagerLocator locator;

    protected Object authorize(Object object) {
        return object;
    }

    protected void addResourceToCreateResponse(Class<?> clz) {
        this.resourcesToCreate.add(clz);
    }

    @Override
    public final Object getById(String type, String id, ListOptions options) {
        return this.authorize(this.getByIdInternal(type, id, options));
    }

    protected Object getByIdInternal(String type, String id, ListOptions options) {
        Map<Object, Object> criteria = this.getDefaultCriteria(true, type);
        criteria.put("id", id);
        return AbstractBaseResourceManager.getFirstFromList(this.listInternal(ApiContext.getSchemaFactory(), type, criteria, options));
    }

    @Override
    public final Object list(String type, ApiRequest request) {
        return this.list(type, new LinkedHashMap<Object, Object>(request.getConditions()), new ListOptions(request));
    }

    @Override
    public final List<?> list(String type, Map<Object, Object> criteria, ListOptions options) {
        criteria = this.mergeCriteria(criteria, this.getDefaultCriteria(false, type));
        Object result = this.authorize(this.listInternal(ApiContext.getSchemaFactory(), type, criteria, options));
        return RequestUtils.toList(result);
    }

    protected Map<Object, Object> mergeCriteria(Map<Object, Object> criteria, Map<Object, Object> other) {
        if (criteria == null) {
            criteria = new LinkedHashMap<Object, Object>();
        }
        for (Map.Entry<Object, Object> entry : other.entrySet()) {
            Object key = entry.getKey();
            Object value = entry.getValue();
            Object existing = criteria.get(key);
            if (existing instanceof List) {
                ArrayList<Object> newCondition = new ArrayList<Object>();
                newCondition.add(value);
                newCondition.addAll((List)existing);
                criteria.put(key, newCondition);
                continue;
            }
            if (existing == null) {
                criteria.put(key, value);
                continue;
            }
            criteria.put(key, Arrays.asList(value, existing));
        }
        return criteria;
    }

    protected abstract Object listInternal(SchemaFactory var1, String var2, Map<Object, Object> var3, ListOptions var4);

    @Override
    public final Object create(String type, ApiRequest request) {
        return this.authorize(this.createInternal(type, request));
    }

    protected abstract Object createInternal(String var1, ApiRequest var2);

    @Override
    public final Object update(String type, String id, ApiRequest request) {
        Object object = this.getById(type, id, new ListOptions(request));
        if (object == null) {
            return null;
        }
        return this.updateInternal(type, id, object, request);
    }

    protected abstract Object updateInternal(String var1, String var2, Object var3, ApiRequest var4);

    @Override
    public final Object delete(String type, String id, ApiRequest request) {
        Object object = this.getById(type, id, new ListOptions(request));
        if (object == null) {
            return null;
        }
        return this.deleteInternal(type, id, object, request);
    }

    protected abstract Object deleteInternal(String var1, String var2, Object var3, ApiRequest var4);

    @Override
    public final Object getLink(String type, String id, String link, ApiRequest request) {
        return this.authorize(this.getLinkInternal(type, id, link, request));
    }

    protected abstract Object getLinkInternal(String var1, String var2, String var3, ApiRequest var4);

    protected Map<Object, Object> getDefaultCriteria(boolean byId, String type) {
        return new HashMap<Object, Object>();
    }

    protected Object getMarker(Pagination pagination) {
        if (pagination == null) {
            return null;
        }
        String marker = pagination.getMarker();
        if (StringUtils.isBlank((CharSequence)marker)) {
            return null;
        }
        if (marker.charAt(0) == 'm') {
            return marker.substring(1);
        }
        String obj = ApiContext.getContext().getIdFormatter().parseId(marker);
        if (obj instanceof Long) {
            return obj;
        }
        if (obj != null) {
            try {
                return new Long(obj.toString());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public Collection convertResponse(List<?> list, ApiRequest request) {
        return this.createCollection(list, request);
    }

    @Override
    public Resource convertResponse(Object obj, ApiRequest request) {
        return this.createResource(obj, ApiContext.getContext().getIdFormatter(), request);
    }

    protected Collection createCollection(List<?> list, ApiRequest request) {
        CollectionImpl collection = new CollectionImpl();
        if (request != null) {
            String collectionType = this.getCollectionType(list, request);
            collection.setResourceType(collectionType);
            Schema schema = request.getSchemaFactory().getSchema(collectionType);
            if (schema != null && schema.getChildren().size() > 0) {
                UrlBuilder urlBuilder = ApiContext.getUrlBuilder();
                TreeMap<String, URL> createTypes = new TreeMap<String, URL>();
                if (schema.getCollectionMethods().contains(Schema.Method.POST.toString())) {
                    createTypes.put(schema.getId(), urlBuilder.resourceCollection(collectionType));
                }
                for (String childType : schema.getChildren()) {
                    schema = request.getSchemaFactory().getSchema(childType);
                    if (schema == null || !schema.getCollectionMethods().contains(Schema.Method.POST.toString())) continue;
                    createTypes.put(schema.getId(), urlBuilder.resourceCollection(schema.getId()));
                }
                if (createTypes.size() > 0) {
                    collection.setCreateTypes(createTypes);
                }
            }
        }
        collection.setCreateDefaults(request.getCreateDefaults());
        IdFormatter formatter = ApiContext.getContext().getIdFormatter();
        this.addSort(collection, request);
        this.addPagination(list, collection, request);
        this.addFilters(collection, request);
        for (Object obj : list) {
            Resource resource = this.createResource(obj, formatter, request);
            if (resource == null) continue;
            collection.getData().add(resource);
            if (collection.getResourceType() != null) continue;
            collection.setResourceType(resource.getType());
        }
        return collection;
    }

    protected String getCollectionType(List<?> list, ApiRequest request) {
        return request.getType();
    }

    protected void addFilters(CollectionImpl collection, ApiRequest request) {
        Schema schema = request.getSchemaFactory().getSchema(collection.getResourceType());
        TreeMap<String, List<Condition>> conditions = new TreeMap<String, List<Condition>>(request.getConditions());
        for (String key : schema.getCollectionFilters().keySet()) {
            if (conditions.containsKey(key)) continue;
            conditions.put(key, null);
        }
        collection.setFilters(conditions);
    }

    protected void addPagination(List<?> list, CollectionImpl collection, ApiRequest request) {
        Pagination pagination = request.getPagination();
        if (pagination == null) {
            return;
        }
        collection.setPagination(pagination.getResponse());
    }

    protected void addSort(CollectionImpl collection, ApiRequest request) {
        UrlBuilder urlBuilder = ApiContext.getUrlBuilder();
        Set<String> sortLinks = this.getSortLinks(request.getSchemaFactory(), collection.getResourceType());
        TreeMap<String, URL> sortLinkMap = new TreeMap<String, URL>();
        for (String sortLink : sortLinks) {
            URL sortUrl = urlBuilder.sort(sortLink);
            if (sortUrl == null) continue;
            sortLinkMap.put(sortLink, sortUrl);
        }
        collection.setSortLinks(sortLinkMap);
        collection.setSort(request.getSort());
    }

    protected Set<String> getSortLinks(SchemaFactory schemaFactory, String type) {
        String key = schemaFactory.getId() + ":sortlinks:" + type;
        Map<String, String> links = this.linksCache.get(key);
        if (links != null) {
            return links.keySet();
        }
        links = new HashMap<String, String>();
        Schema schema = schemaFactory.getSchema(type);
        if (schema == null) {
            return Collections.emptySet();
        }
        for (String name : schema.getCollectionFilters().keySet()) {
            links.put(name, name);
        }
        this.linksCache.put(key, links);
        return links.keySet();
    }

    protected Resource createResource(Object obj, IdFormatter idFormatter, ApiRequest apiRequest) {
        String type;
        ResourceManager rm;
        SchemaFactory schemaFactory;
        if (obj == null) {
            return null;
        }
        if (obj instanceof Resource) {
            return (Resource)obj;
        }
        SchemaFactory schemaFactory2 = schemaFactory = apiRequest == null ? ApiContext.getSchemaFactory() : apiRequest.getSchemaFactory();
        if (this.resourcesToCreate.size() > 0 && !this.resourcesToCreate.contains(obj.getClass()) && (rm = this.locator.getResourceManagerByType(type = schemaFactory.getSchemaName(obj.getClass()))) != null) {
            return rm.convertResponse(obj, apiRequest);
        }
        Schema schema = this.getSchemaForDisplay(schemaFactory, obj);
        if (schema == null) {
            return null;
        }
        Resource resource = this.constructResource(idFormatter, schemaFactory, schema, obj);
        this.addLinks(obj, schemaFactory, schema, resource);
        this.addActions(obj, schemaFactory, schema, resource);
        return resource;
    }

    protected Schema getSchemaForDisplay(SchemaFactory schemaFactory, Object obj) {
        return schemaFactory.getSchema(obj.getClass());
    }

    protected void addActions(Object obj, SchemaFactory schemaFactory, Schema schema, Resource resource) {
        Map<String, Action> actions = schema.getResourceActions();
        if (actions == null || actions.size() == 0) {
            return;
        }
        UrlBuilder urlBuilder = ApiContext.getUrlBuilder();
        for (String name : actions.keySet()) {
            resource.getActions().put(name, urlBuilder.actionLink(resource, name));
        }
    }

    protected Resource constructResource(IdFormatter idFormatter, SchemaFactory schemaFactory, Schema schema, Object obj) {
        return new WrappedResource(idFormatter, schema, obj);
    }

    protected void addLinks(Object obj, SchemaFactory schemaFactory, Schema schema, Resource resource) {
        Map<String, URL> links = resource.getLinks();
        for (Map.Entry<String, String> entry : this.getLinks(schemaFactory, resource).entrySet()) {
            String linkName = entry.getKey();
            String propName = entry.getValue();
            URL link = ApiContext.getUrlBuilder().resourceLink(resource, linkName);
            if (link == null || propName != null && resource.getFields().get(propName) == null) continue;
            links.put(linkName, link);
        }
    }

    protected Map<String, String> getLinks(SchemaFactory schemaFactory, Resource resource) {
        return new HashMap<String, String>();
    }

    public static Object getFirstFromList(Object obj) {
        if (obj instanceof Collection) {
            return AbstractBaseResourceManager.getFirstFromList(((Collection)obj).getData());
        }
        if (obj instanceof List) {
            List list = (List)obj;
            return list.size() > 0 ? list.get(0) : null;
        }
        return null;
    }

    @Override
    public boolean handleException(Throwable t, ApiRequest request) {
        return false;
    }

    @Override
    public final Object resourceAction(String type, ApiRequest request) {
        Object resource = this.getById(type, request.getId(), new ListOptions());
        if (resource == null) {
            return null;
        }
        return this.resourceActionInternal(resource, request);
    }

    protected abstract Object resourceActionInternal(Object var1, ApiRequest var2);

    @Override
    public final Object collectionAction(String type, ApiRequest request) {
        Object resources = this.list(type, request);
        if (resources == null) {
            return null;
        }
        return this.collectionActionInternal(resources, request);
    }

    protected abstract Object collectionActionInternal(Object var1, ApiRequest var2);

    public ResourceManagerLocator getLocator() {
        return this.locator;
    }

    @Inject
    public void setLocator(ResourceManagerLocator locator) {
        this.locator = locator;
    }
}

