/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.request.handler;

import io.github.ibuildthecloud.gdapi.model.ListOptions;
import io.github.ibuildthecloud.gdapi.model.Schema;
import io.github.ibuildthecloud.gdapi.request.ApiRequest;
import io.github.ibuildthecloud.gdapi.request.handler.AbstractResponseGenerator;
import io.github.ibuildthecloud.gdapi.request.resource.ResourceManager;
import io.github.ibuildthecloud.gdapi.request.resource.ResourceManagerLocator;
import java.io.IOException;
import javax.inject.Inject;

public class ResourceManagerRequestHandler
extends AbstractResponseGenerator {
    ResourceManagerLocator resourceManagerLocator;

    @Override
    protected void generate(ApiRequest request) throws IOException {
        ResourceManager manager = this.resourceManagerLocator.getResourceManager(request);
        if (manager == null) {
            return;
        }
        Object response = null;
        String method = request.getMethod();
        if (Schema.Method.POST.isMethod(method)) {
            if (request.getAction() == null) {
                request.setResponseCode(201);
                response = manager.create(request.getType(), request);
            } else {
                response = request.getId() == null ? manager.collectionAction(request.getType(), request) : manager.resourceAction(request.getType(), request);
            }
        } else if (Schema.Method.PUT.isMethod(method)) {
            response = manager.update(request.getType(), request.getId(), request);
        } else if (Schema.Method.GET.isMethod(method)) {
            if (request.getId() != null && request.getLink() == null) {
                response = manager.getById(request.getType(), request.getId(), new ListOptions(request));
            } else if (request.getType() != null && request.getLink() != null) {
                response = manager.getLink(request.getType(), request.getId(), request.getLink(), request);
            } else if (request.getType() != null) {
                response = manager.list(request.getType(), request);
            }
        } else if (Schema.Method.DELETE.isMethod(method)) {
            response = manager.delete(request.getType(), request.getId(), request);
        }
        request.setResponseObject(response);
    }

    @Override
    public boolean handleException(ApiRequest request, Throwable e) {
        ResourceManager manager = this.resourceManagerLocator.getResourceManager(request);
        if (manager == null) {
            return super.handleException(request, e);
        }
        return manager.handleException(e, request);
    }

    public ResourceManagerLocator getResourceManagerLocator() {
        return this.resourceManagerLocator;
    }

    @Inject
    public void setResourceManagerLocator(ResourceManagerLocator resourceManagerLocator) {
        this.resourceManagerLocator = resourceManagerLocator;
    }
}

