/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.model.impl;

import io.github.ibuildthecloud.gdapi.id.IdFormatter;
import io.github.ibuildthecloud.gdapi.id.IdFormatterUtils;
import io.github.ibuildthecloud.gdapi.model.Field;
import io.github.ibuildthecloud.gdapi.model.FieldType;
import io.github.ibuildthecloud.gdapi.model.Resource;
import io.github.ibuildthecloud.gdapi.model.Schema;
import io.github.ibuildthecloud.gdapi.model.impl.ResourceImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlTransient;

public class WrappedResource
extends ResourceImpl
implements Resource {
    Schema schema;
    Object obj;
    Map<String, Object> fields = new LinkedHashMap<String, Object>();
    Map<String, Object> additionalFields;
    Map<String, Field> resourceFields;
    boolean createTsFields = true;
    IdFormatter idFormatter;

    public WrappedResource(IdFormatter idFormatter, Schema schema, Object obj, Map<String, Object> additionalFields) {
        this.schema = schema;
        this.resourceFields = schema.getResourceFields();
        this.obj = obj;
        this.idFormatter = idFormatter;
        this.additionalFields = additionalFields;
        this.init();
    }

    public WrappedResource(IdFormatter idFormatter, Schema schema, Object obj) {
        this(idFormatter, schema, obj, new HashMap<String, Object>());
    }

    protected void init() {
        for (Map.Entry<String, Field> entry : this.resourceFields.entrySet()) {
            Field field;
            String name = entry.getKey();
            if (name.equals("id") || !(field = entry.getValue()).isIncludeInList()) continue;
            Object value = this.additionalFields.remove(name);
            if (value == null) {
                value = field.getValue(this.obj);
            }
            this.fields.put(name, IdFormatterUtils.formatReference(field, this.idFormatter, value));
            if (!this.createTsFields || field.getTypeEnum() != FieldType.DATE || !(value instanceof Date)) continue;
            this.fields.put(name + "TS", ((Date)value).getTime());
        }
        for (Map.Entry<String, Object> entry : this.additionalFields.entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey();
            Field field = this.resourceFields.get(key);
            if ((field == null || !field.isIncludeInList()) && !this.isResource(value)) continue;
            this.fields.put(key, value);
        }
        this.setId(this.idFormatter.formatId(this.getType(), this.getIdValue()));
    }

    protected boolean isResource(Object obj) {
        List list;
        if (obj instanceof Resource) {
            return true;
        }
        return obj instanceof List && ((list = (List)obj).size() == 0 || this.isResource(list.get(0)));
    }

    protected Object getIdValue() {
        Field idField = this.schema.getResourceFields().get("id");
        return idField == null ? null : idField.getValue(this.obj);
    }

    @Override
    public String getType() {
        return this.schema.getId();
    }

    @Override
    public Map<String, Object> getFields() {
        return this.fields;
    }

    @XmlTransient
    public boolean isCreateTsFields() {
        return this.createTsFields;
    }

    public void setCreateTsFields(boolean createTsFields) {
        this.createTsFields = createTsFields;
    }
}

