/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.model.impl;

import io.github.ibuildthecloud.gdapi.context.ApiContext;
import io.github.ibuildthecloud.gdapi.model.Action;
import io.github.ibuildthecloud.gdapi.model.Field;
import io.github.ibuildthecloud.gdapi.model.Filter;
import io.github.ibuildthecloud.gdapi.model.Schema;
import io.github.ibuildthecloud.gdapi.model.impl.FieldImpl;
import io.github.ibuildthecloud.gdapi.model.impl.ResourceImpl;
import io.github.ibuildthecloud.gdapi.util.TypeUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlTransient;

public class SchemaImpl
extends ResourceImpl
implements Schema {
    String name;
    String parent;
    String pluralName;
    List<String> children = new ArrayList<String>();
    boolean create;
    boolean update;
    boolean list = true;
    boolean deletable;
    boolean byId = true;
    Map<String, Field> resourceFields = new TreeMap<String, Field>();
    Map<String, Filter> collectionFilters = new TreeMap<String, Filter>();
    List<String> includeableLinks = new ArrayList<String>();
    Map<String, Action> resourceActions = new HashMap<String, Action>();
    Map<String, Action> collectionActions = new HashMap<String, Action>();
    Map<String, Field> collectionFields = new HashMap<String, Field>();

    public SchemaImpl() {
        this.setType("schema");
    }

    public SchemaImpl(SchemaImpl schema) {
        this();
        this.name = schema.getId();
        this.parent = schema.getParent();
        this.children = new ArrayList<String>(schema.getChildren());
        this.pluralName = schema.getPluralName();
        this.load(schema);
    }

    public void load(SchemaImpl schema) {
        this.create = schema.isCreate();
        this.update = schema.isUpdate();
        this.list = schema.isList();
        this.deletable = schema.isDeletable();
        this.byId = schema.isById();
        this.includeableLinks = new ArrayList<String>(schema.getIncludeableLinks());
        this.resourceFields = this.copyFields(schema.getResourceFields());
        this.collectionFilters = this.copyFilters(schema.getCollectionFilters());
        this.resourceActions = this.copyActions(schema.getResourceActions());
        this.collectionActions = this.copyActions(schema.getCollectionActions());
        this.collectionFields = this.copyFields(schema.getCollectionFields());
    }

    protected Map<String, Field> copyFields(Map<String, Field> input) {
        LinkedHashMap<String, Field> result = new LinkedHashMap<String, Field>();
        for (String key : input.keySet()) {
            result.put(key, new FieldImpl(input.get(key)));
        }
        return result;
    }

    protected Map<String, Filter> copyFilters(Map<String, Filter> input) {
        LinkedHashMap<String, Filter> result = new LinkedHashMap<String, Filter>();
        for (String key : input.keySet()) {
            result.put(key, new Filter(input.get(key)));
        }
        return result;
    }

    protected Map<String, Action> copyActions(Map<String, Action> input) {
        LinkedHashMap<String, Action> result = new LinkedHashMap<String, Action>();
        for (String key : input.keySet()) {
            result.put(key, new Action(input.get(key)));
        }
        return result;
    }

    @Override
    public String getId() {
        return this.name;
    }

    @Override
    public void setId(String name) {
        this.name = name;
    }

    @Override
    public Map<String, Field> getResourceFields() {
        return this.resourceFields;
    }

    public void setResourceFields(Map<String, Field> resourceFields) {
        this.resourceFields = resourceFields;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlTransient
    public boolean isCreate() {
        return this.create;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    @XmlTransient
    public boolean isUpdate() {
        return this.update;
    }

    public void setUpdate(boolean update) {
        this.update = update;
    }

    @XmlTransient
    public boolean isList() {
        return this.list;
    }

    public void setList(boolean list) {
        this.list = list;
    }

    public boolean isDeletable() {
        return this.deletable;
    }

    @XmlTransient
    public void setDeletable(boolean deletable) {
        this.deletable = deletable;
    }

    @XmlTransient
    public boolean isById() {
        return this.byId;
    }

    public void setById(boolean byId) {
        this.byId = byId;
    }

    public void setResourceMethods(List<String> resourceMethods) {
        if (resourceMethods == null) {
            this.byId = false;
            this.update = false;
            this.deletable = false;
            return;
        }
        this.byId = resourceMethods.contains(Schema.Method.GET.toString());
        this.update = resourceMethods.contains(Schema.Method.PUT.toString());
        this.deletable = resourceMethods.contains(Schema.Method.DELETE.toString());
    }

    @Override
    public List<String> getResourceMethods() {
        ArrayList<String> methods = new ArrayList<String>();
        if (this.byId) {
            methods.add(Schema.Method.GET.toString());
        }
        if (this.update) {
            methods.add(Schema.Method.PUT.toString());
        }
        if (this.deletable) {
            methods.add(Schema.Method.DELETE.toString());
        }
        return methods;
    }

    public void setCollectionMethods(List<String> collectionMethods) {
        if (collectionMethods == null) {
            this.list = false;
            this.create = false;
            return;
        }
        this.list = collectionMethods.contains(Schema.Method.GET.toString());
        this.create = collectionMethods.contains(Schema.Method.POST.toString());
    }

    @Override
    public List<String> getCollectionMethods() {
        ArrayList<String> methods = new ArrayList<String>();
        if (this.list) {
            methods.add(Schema.Method.GET.toString());
        }
        if (this.create) {
            methods.add(Schema.Method.POST.toString());
        }
        return methods;
    }

    @Override
    public Map<String, URL> getLinks() {
        HashMap<String, URL> result = this.links;
        if (!this.links.containsKey("self")) {
            result = new HashMap<String, URL>(this.links);
            result.put("self", ApiContext.getUrlBuilder().resourceReferenceLink(this));
        }
        if (this.list && !result.containsKey("collection")) {
            result = result == null ? new HashMap<String, URL>(this.links) : result;
            result.put("collection", ApiContext.getUrlBuilder().resourceCollection(this.getId()));
        }
        return result == null ? this.links : result;
    }

    @Override
    public Map<String, Action> getResourceActions() {
        return this.resourceActions;
    }

    @Override
    public Map<String, Action> getCollectionActions() {
        return this.collectionActions;
    }

    @Override
    public Map<String, Field> getCollectionFields() {
        return this.collectionFields;
    }

    @Override
    public Map<String, Filter> getCollectionFilters() {
        return this.collectionFilters;
    }

    @Override
    @XmlTransient
    public String getPluralName() {
        if (this.pluralName == null) {
            return TypeUtils.guessPluralName(this.name);
        }
        return this.pluralName;
    }

    public void setPluralName(String pluralName) {
        this.pluralName = pluralName;
    }

    @XmlTransient
    public String getRawPluralName() {
        return this.pluralName;
    }

    @Override
    public List<String> getIncludeableLinks() {
        return this.includeableLinks;
    }

    public void setIncludeableLinks(List<String> includeableLinks) {
        this.includeableLinks = includeableLinks;
    }

    public String toString() {
        return "SchemaImpl [name=" + this.name + "]";
    }

    public void setCollectionFilters(Map<String, Filter> collectionFilters) {
        this.collectionFilters = collectionFilters;
    }

    public void setCollectionActions(Map<String, Action> collectionActions) {
        this.collectionActions = collectionActions;
    }

    public void setCollectionFields(Map<String, Field> collectionFields) {
        this.collectionFields = collectionFields;
    }

    public void setResourceActions(Map<String, Action> resourceActions) {
        this.resourceActions = resourceActions;
    }

    @Override
    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    @Override
    public List<String> getChildren() {
        return this.children;
    }
}

