/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.validation;

import io.github.ibuildthecloud.gdapi.context.ApiContext;
import io.github.ibuildthecloud.gdapi.exception.ClientVisibleException;
import io.github.ibuildthecloud.gdapi.factory.SchemaFactory;
import io.github.ibuildthecloud.gdapi.id.IdFormatter;
import io.github.ibuildthecloud.gdapi.model.Action;
import io.github.ibuildthecloud.gdapi.model.Field;
import io.github.ibuildthecloud.gdapi.model.FieldType;
import io.github.ibuildthecloud.gdapi.model.Resource;
import io.github.ibuildthecloud.gdapi.model.Schema;
import io.github.ibuildthecloud.gdapi.model.impl.ValidationErrorImpl;
import io.github.ibuildthecloud.gdapi.request.ApiRequest;
import io.github.ibuildthecloud.gdapi.request.handler.AbstractApiRequestHandler;
import io.github.ibuildthecloud.gdapi.util.DateUtils;
import io.github.ibuildthecloud.gdapi.util.RequestUtils;
import io.github.ibuildthecloud.gdapi.validation.ReferenceValidator;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ValidationHandler
extends AbstractApiRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(ValidationHandler.class);
    ReferenceValidator referenceValidator;
    Set<String> supportedMethods;

    @Override
    public void handle(ApiRequest request) throws IOException {
        ValidationContext context = new ValidationContext();
        context.schemaFactory = request.getSchemaFactory();
        context.idFormatter = ApiContext.getContext().getIdFormatter();
        context.schema = context.schemaFactory.getSchema(request.getType());
        this.validateVersion(request, context);
        this.validateId(request, context);
        this.validateType(request, context);
        this.validateAction(request, context);
        this.validateMethod(request, context);
        this.validateField(request, context);
    }

    protected void validateAction(ApiRequest request, ValidationContext context) {
        String input;
        Map<String, Action> actions;
        String action = request.getAction();
        if (action == null || !Schema.Method.POST.isMethod(request.getMethod())) {
            return;
        }
        Map<String, Action> map = actions = request.getId() == null ? context.schema.getCollectionActions() : context.schema.getResourceActions();
        if (actions == null || !actions.containsKey(action)) {
            this.error("InvalidAction", "action");
        }
        if (this.referenceValidator != null && request.getId() != null) {
            Resource resource = this.referenceValidator.getResourceId(request.getType(), request.getId());
            if (resource == null) {
                this.error(404);
            }
            if (!resource.getActions().containsKey(action)) {
                this.error("ActionNotAvailable", "action");
            }
        }
        if ((input = actions.get(action).getInput()) != null) {
            Schema inputSchema = context.schemaFactory.getSchema(input);
            if (inputSchema == null) {
                log.error("Failed to find input schema [{}] for action [{}] on type [{}]", new Object[]{input, action, request.getType()});
                this.error(404);
            } else {
                context.actionSchema = inputSchema;
            }
        }
    }

    protected void validateType(ApiRequest request, ValidationContext context) {
        if (request.getType() != null && context.schema == null) {
            this.error(404);
        }
    }

    protected void validateField(ApiRequest request, ValidationContext context) {
        if (RequestUtils.isReadMethod(request.getMethod())) {
            this.validateReadField(request, context);
        } else {
            this.validateWriteField(request, context);
        }
    }

    protected void validateReadField(ApiRequest request, ValidationContext context) {
        request.setRequestObject(new HashMap());
    }

    protected void validateWriteField(ApiRequest request, ValidationContext context) {
        if (Schema.Method.PUT.isMethod(request.getMethod())) {
            this.validateOperationField(context.schema, request, false, context);
        } else if (Schema.Method.POST.isMethod(request.getMethod())) {
            if (request.getAction() == null) {
                this.validateOperationField(context.schema, request, true, context);
            } else {
                this.validateOperationField(context.actionSchema, request, true, context);
            }
        }
    }

    protected void validateOperationField(Schema schema, ApiRequest request, boolean create, ValidationContext context) {
        String fieldName;
        if (schema == null) {
            return;
        }
        String type = request.getType();
        Map input = RequestUtils.toMap(request.getRequestObject());
        LinkedHashMap<String, Object> sanitized = new LinkedHashMap<String, Object>();
        Map<String, Field> fields = schema.getResourceFields();
        for (Map.Entry entry : input.entrySet()) {
            Field field;
            fieldName = (String)entry.getKey();
            Object value = entry.getValue();
            if (!create && "id".equals(fieldName) || (field = fields.get(fieldName)) == null || !this.isOperation(field, create)) continue;
            boolean wasNull = value == null;
            if ((value = this.convert(fieldName, field, value, context)) == null && !wasNull) continue;
            if (value instanceof List) {
                for (Object individualValue : (List)value) {
                    this.checkFieldCriteria(type, fieldName, field, individualValue);
                }
            } else {
                this.checkFieldCriteria(type, fieldName, field, value);
            }
            sanitized.put(fieldName, value);
        }
        for (Map.Entry<Object, Object> entry : fields.entrySet()) {
            List<Object> list;
            fieldName = (String)entry.getKey();
            Field field = (Field)entry.getValue();
            if (create && !sanitized.containsKey(fieldName) && field.hasDefault()) {
                sanitized.put(fieldName, field.getDefault());
            }
            if (!this.isOperation(field, create) || !field.isRequired()) continue;
            if (!sanitized.containsKey(fieldName)) {
                this.error("MissingRequired", fieldName);
            }
            if (field.getTypeEnum() != FieldType.ARRAY || (list = this.convertArray(fieldName, null, null, sanitized.get(fieldName), context)) == null || list.size() != 0) continue;
            this.error("MissingRequired", fieldName);
        }
        request.setRequestObject(sanitized);
    }

    protected boolean isOperation(Field field, boolean create) {
        return create && field.isCreate() || !create && field.isUpdate();
    }

    protected Object convert(String fieldName, Field field, Object value, ValidationContext context) {
        return this.convert(fieldName, field.getTypeEnum(), field.getSubTypeEnums(), field.getSubTypes(), value, context);
    }

    protected Object convert(String fieldName, FieldType type, List<FieldType> subTypes, List<String> subTypeNames, Object value, ValidationContext context) {
        if (value == null) {
            return value;
        }
        switch (type) {
            case MAP: {
                return this.checkType(fieldName, value, Map.class);
            }
            case DATE: {
                return this.convertDate(fieldName, value);
            }
            case ARRAY: {
                if (subTypes.size() == 0) {
                    return this.error("InvalidFormat", fieldName);
                }
                return this.convertArray(fieldName, subTypes, subTypeNames, value, context);
            }
            case BLOB: {
                return this.checkType(fieldName, value, InputStream.class);
            }
            case BOOLEAN: 
            case ENUM: 
            case FLOAT: 
            case INT: 
            case PASSWORD: 
            case STRING: {
                return this.convertGenericType(fieldName, value, type);
            }
            case REFERENCE: {
                if (subTypeNames.size() == 0) {
                    return this.error("InvalidFormat", fieldName);
                }
                return this.convertReference(subTypeNames.get(0), fieldName, value, context);
            }
        }
        throw new IllegalStateException("Do not know how to convert type [" + (Object)((Object)type) + "]");
    }

    protected Object convertReference(String type, String fieldName, Object value, ValidationContext context) {
        Object referenced;
        String id = context.idFormatter.parseId(value.toString());
        if (id == null) {
            this.error("InvalidReference", fieldName);
        }
        if (this.referenceValidator != null && (referenced = this.referenceValidator.getById(type, id)) == null) {
            this.error("InvalidReference", fieldName);
        }
        try {
            return new Long(id);
        }
        catch (NumberFormatException nfe) {
            return id;
        }
    }

    protected Object convertGenericType(String fieldName, Object value, FieldType type) {
        if (type.getClasses().length == 0) {
            return this.error("InvalidFormat", fieldName);
        }
        Class<?> clz = type.getClasses()[0];
        if ((value = ConvertUtils.convert((Object)value, clz)) == null || !clz.isAssignableFrom(value.getClass())) {
            return this.error("InvalidFormat", fieldName);
        }
        return value;
    }

    protected Object checkType(String fieldName, Object value, Class<?> type) {
        if (type.isAssignableFrom(value.getClass())) {
            return value;
        }
        return this.error("InvalidFormat", fieldName);
    }

    protected List<Object> convertArray(String fieldName, List<FieldType> subTypes, List<String> subTypesNames, Object value, ValidationContext context) {
        ArrayList<Object> result = new ArrayList<Object>();
        List<Object> items = null;
        items = value instanceof Object[] ? Arrays.asList(value) : (value instanceof List ? (List<Object>)value : Arrays.asList(value));
        if (subTypes == null) {
            result.addAll(items);
            return result;
        }
        FieldType type = subTypes.get(0);
        for (Object item : items) {
            item = this.convert(fieldName, type, subTypes.subList(1, subTypes.size()), subTypesNames.subList(1, subTypesNames.size()), item, context);
            result.add(item);
        }
        return result;
    }

    protected Object convertDate(String fieldName, Object value) {
        if (value instanceof Date) {
            return value;
        }
        try {
            if (StringUtils.isBlank((CharSequence)value.toString())) {
                return null;
            }
            return DateUtils.parse(value.toString());
        }
        catch (ParseException e) {
            return this.error("InvalidDateFormat", fieldName);
        }
    }

    protected void checkFieldCriteria(String type, String fieldName, Field field, Object inputValue) {
        Object value = inputValue;
        Number numVal = null;
        String stringValue = null;
        Long minLength = field.getMinLength();
        Long maxLength = field.getMaxLength();
        Long min = field.getMin();
        Long max = field.getMax();
        List<String> options = field.getOptions();
        String validChars = field.getValidChars();
        String invalidChars = field.getInvalidChars();
        if (value == null && field.getDefault() != null) {
            value = field.getDefault();
        }
        if (value instanceof Number) {
            numVal = (Number)value;
        }
        if (value != null) {
            stringValue = value.toString();
        }
        if (value == null && !field.isNullable()) {
            this.error("NotNullable", fieldName);
        }
        if (value != null && field.isUnique() && this.referenceValidator != null && this.referenceValidator.getByField(type, fieldName, value) != null) {
            this.error("NotUnique", fieldName);
        }
        if (numVal != null) {
            if (min != null && numVal.longValue() < min) {
                this.error("MinLimitExceeded", fieldName);
            }
            if (max != null && numVal.longValue() > max) {
                this.error("MaxLimitExceeded", fieldName);
            }
        }
        if (stringValue != null) {
            if (minLength != null && (long)stringValue.length() < minLength) {
                this.error("MinLengthExceeded", fieldName);
            }
            if (maxLength != null && (long)stringValue.length() > maxLength) {
                this.error("MaxLengthExceeded", fieldName);
            }
        }
        if (options != null && options.size() > 0 && !options.contains(stringValue)) {
            this.error("InvalidOption", fieldName);
        }
        if (validChars != null && stringValue != null && !stringValue.matches("^[" + validChars + "]*$")) {
            this.error("InvalidCharacters", fieldName);
        }
        if (invalidChars != null && stringValue != null && stringValue.matches("^[" + invalidChars + "]*$")) {
            this.error("InvalidCharacters", fieldName);
        }
    }

    protected void validateVersion(ApiRequest request, ValidationContext context) {
        String version = request.getRequestVersion();
        if (version != null && !request.getApiVersion().equals(version)) {
            this.error("UnsupportedVersion", null);
        }
    }

    protected void validateId(ApiRequest request, ValidationContext context) {
        String id = request.getId();
        if (id == null) {
            return;
        }
        if (context.schemaFactory.typeStringMatches(Schema.class, request.getType())) {
            return;
        }
        String formattedId = context.idFormatter.parseId(id);
        if (formattedId == null) {
            this.error(404);
        } else {
            request.setId(formattedId);
        }
    }

    protected void validateMethod(ApiRequest request, ValidationContext context) {
        List<String> allowed;
        String method = request.getMethod();
        if (request.getAction() != null && Schema.Method.POST.isMethod(method)) {
            return;
        }
        if (method == null || !this.supportedMethods.contains(method)) {
            this.error(405);
        }
        String type = request.getType();
        String id = request.getId();
        if (type == null || context.schema == null) {
            return;
        }
        List<String> list = allowed = id == null ? context.schema.getCollectionMethods() : context.schema.getResourceMethods();
        if (!allowed.contains(method)) {
            this.error(405);
        }
    }

    protected Object error(String code, String fieldName) {
        ValidationErrorImpl error = new ValidationErrorImpl(code, fieldName);
        throw new ClientVisibleException(error);
    }

    protected Object error(int code) {
        throw new ClientVisibleException(code);
    }

    @PostConstruct
    public void init() {
        if (this.supportedMethods == null) {
            this.supportedMethods = new HashSet<String>();
            for (Schema.Method m : Schema.Method.values()) {
                this.supportedMethods.add(m.toString());
            }
        }
    }

    public Set<String> getSupportedMethods() {
        return this.supportedMethods;
    }

    public void setSupportedMethods(Set<String> supportedMethods) {
        this.supportedMethods = supportedMethods;
    }

    public ReferenceValidator getReferenceValidator() {
        return this.referenceValidator;
    }

    public void setReferenceValidator(ReferenceValidator referenceValidator) {
        this.referenceValidator = referenceValidator;
    }

    private static final class ValidationContext {
        SchemaFactory schemaFactory;
        Schema schema;
        Schema actionSchema;
        IdFormatter idFormatter;

        private ValidationContext() {
        }
    }
}

