/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.response.impl;

import io.github.ibuildthecloud.gdapi.factory.SchemaFactory;
import io.github.ibuildthecloud.gdapi.model.Resource;
import io.github.ibuildthecloud.gdapi.response.ResourceOutputFilter;
import io.github.ibuildthecloud.gdapi.response.ResourceOutputFilterManager;
import io.github.ibuildthecloud.gdapi.response.impl.ResourceOutputFilterChain;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;

public class ResourceOutputFilterManagerImpl
implements ResourceOutputFilterManager {
    SchemaFactory baseSchemaFactory;
    List<ResourceOutputFilter> outputFilters;
    Map<String, ResourceOutputFilter> filtersByType;

    @Override
    public ResourceOutputFilter getOutputFilter(Resource resource) {
        if (resource == null) {
            return null;
        }
        return this.getFiltersByType().get(resource.getType());
    }

    protected Map<String, ResourceOutputFilter> getFiltersByType() {
        if (this.filtersByType != null) {
            return this.filtersByType;
        }
        HashMap<String, ResourceOutputFilter> result = new HashMap<String, ResourceOutputFilter>();
        for (ResourceOutputFilter filter : this.outputFilters) {
            HashSet<String> types = new HashSet<String>();
            for (String type : filter.getTypes()) {
                types.add(type);
            }
            for (Class<?> clz : filter.getTypeClasses()) {
                String type = this.baseSchemaFactory.getSchemaName(clz);
                if (type == null) continue;
                types.add(type);
            }
            for (String type : types) {
                ResourceOutputFilter next = (ResourceOutputFilter)result.get(type);
                if (next == null) {
                    result.put(type, filter);
                    continue;
                }
                result.put(type, new ResourceOutputFilterChain(filter, next));
            }
        }
        this.filtersByType = result;
        return this.filtersByType;
    }

    public List<ResourceOutputFilter> getOutputFilters() {
        return this.outputFilters;
    }

    @Inject
    public void setOutputFilters(List<ResourceOutputFilter> outputFilters) {
        this.outputFilters = outputFilters;
    }

    public SchemaFactory getBaseSchemaFactory() {
        return this.baseSchemaFactory;
    }

    public void setBaseSchemaFactory(SchemaFactory baseSchemaFactory) {
        this.baseSchemaFactory = baseSchemaFactory;
    }
}

