/*
 * Decompiled with CFR 0.152.
 */
package io.github.ibuildthecloud.gdapi.factory.impl;

import io.github.ibuildthecloud.gdapi.annotation.Action;
import io.github.ibuildthecloud.gdapi.annotation.Actions;
import io.github.ibuildthecloud.gdapi.annotation.Field;
import io.github.ibuildthecloud.gdapi.annotation.Type;
import io.github.ibuildthecloud.gdapi.factory.SchemaFactory;
import io.github.ibuildthecloud.gdapi.factory.impl.AbstractSchemaFactory;
import io.github.ibuildthecloud.gdapi.factory.impl.SchemaPostProcessor;
import io.github.ibuildthecloud.gdapi.model.ApiError;
import io.github.ibuildthecloud.gdapi.model.ApiVersion;
import io.github.ibuildthecloud.gdapi.model.Collection;
import io.github.ibuildthecloud.gdapi.model.FieldType;
import io.github.ibuildthecloud.gdapi.model.Resource;
import io.github.ibuildthecloud.gdapi.model.Schema;
import io.github.ibuildthecloud.gdapi.model.impl.FieldImpl;
import io.github.ibuildthecloud.gdapi.model.impl.SchemaImpl;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import javax.annotation.PostConstruct;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang3.StringUtils;

@Type
public class SchemaFactoryImpl
extends AbstractSchemaFactory
implements SchemaFactory {
    final Field defaultField;
    final Type defaultType;
    String id = UUID.randomUUID().toString();
    boolean includeDefaultTypes = true;
    boolean writableByDefault = false;
    Map<String, SchemaImpl> schemasByName = new TreeMap<String, SchemaImpl>();
    Map<Class<?>, SchemaImpl> schemasByClass = new HashMap();
    Map<String, Class<?>> typeToClass = new HashMap();
    List<Class<?>> types = new ArrayList();
    List<String> typeNames = new ArrayList<String>();
    Map<SchemaImpl, Class<?>> parentClasses = new HashMap();
    List<Schema> schemasList = new ArrayList<Schema>();
    List<SchemaPostProcessor> postProcessors = new ArrayList<SchemaPostProcessor>();

    public SchemaFactoryImpl() {
        try {
            this.defaultField = PropertyUtils.getPropertyDescriptor((Object)this, (String)"defaultField").getReadMethod().getAnnotation(Field.class);
            this.defaultType = this.getClass().getAnnotation(Type.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Field
    public Object getDefaultField() {
        return null;
    }

    @Override
    public Schema registerSchema(Object obj) {
        Class clz = obj instanceof Class ? (Class)obj : null;
        SchemaImpl schema = this.schemaFromObject(obj);
        for (SchemaPostProcessor processor : this.postProcessors) {
            schema = processor.postProcessRegister(schema, this);
            if (schema != null) continue;
            return null;
        }
        if (clz != null) {
            this.addToMap(this.typeToClass, schema, clz);
        }
        this.addToMap(this.schemasByName, schema, schema);
        if (clz != null) {
            this.schemasByClass.put(clz, schema);
            for (Class<?> iface : clz.getInterfaces()) {
                this.schemasByClass.put(iface, schema);
            }
        }
        this.schemasList.add(schema);
        return schema;
    }

    protected <T> void addToMap(Map<String, T> map, SchemaImpl key, T value) {
        if (key == null || value == null) {
            return;
        }
        map.put(key.getId(), value);
        map.put(key.getId().toLowerCase(), value);
        map.put(key.getPluralName(), value);
        map.put(key.getPluralName().toLowerCase(), value);
    }

    @Override
    public Schema getSchema(Class<?> clz) {
        return this.schemasByClass.get(clz);
    }

    @Override
    public Schema parseSchema(String name) {
        SchemaImpl schema = this.readSchema(name);
        Class<?> clz = this.typeToClass.get(name);
        this.processParent(schema);
        List<io.github.ibuildthecloud.gdapi.model.Field> fields = this.getFields(clz);
        for (Map.Entry<String, io.github.ibuildthecloud.gdapi.model.Field> entry : schema.getResourceFields().entrySet()) {
            io.github.ibuildthecloud.gdapi.model.Field field = entry.getValue();
            if (field instanceof FieldImpl) {
                ((FieldImpl)field).setName(entry.getKey());
            }
            fields.add(field);
        }
        Map<String, io.github.ibuildthecloud.gdapi.model.Field> resourceFields = this.sortFields(fields);
        schema.setResourceFields(resourceFields);
        schema.getResourceActions().putAll(this.getResourceActions(clz));
        schema.getCollectionActions().putAll(this.getCollectionActions(clz));
        for (SchemaPostProcessor processor : this.postProcessors) {
            schema = processor.postProcess(schema, this);
        }
        this.addToMap(this.schemasByName, schema, schema);
        if (clz == null && schema.getParent() != null && (clz = this.typeToClass.get(schema.getParent())) != null) {
            this.addToMap(this.typeToClass, schema, clz);
        }
        return schema;
    }

    protected void processParent(SchemaImpl schema) {
        SchemaImpl parent = null;
        Class<?> parentClass = this.parentClasses.get(schema);
        String parentName = schema.getParent();
        if (parentClass == null && parentName != null) {
            parent = this.schemasByName.get(parentName);
            if (parent == null) {
                throw new IllegalArgumentException("Failed to find parent schema for [" + parentName + "] for type [" + schema.getId() + "]");
            }
        } else if (parentClass != null && (parent = this.schemasByClass.get(parentClass)) == null) {
            throw new IllegalArgumentException("Failed to find parent schema for class [" + parentClass + "] for type [" + schema.getId() + "]");
        }
        if (parent != null) {
            schema.setParent(parent.getId());
            parent.getChildren().add(schema.getId());
            schema.load(parent);
        }
    }

    protected Map<String, io.github.ibuildthecloud.gdapi.model.Action> getCollectionActions(Class<?> clz) {
        return this.getActions(clz, true);
    }

    protected Map<String, io.github.ibuildthecloud.gdapi.model.Action> getResourceActions(Class<?> clz) {
        return this.getActions(clz, false);
    }

    protected Map<String, io.github.ibuildthecloud.gdapi.model.Action> getActions(Class<?> clz, boolean collection) {
        LinkedHashMap<String, io.github.ibuildthecloud.gdapi.model.Action> result = new LinkedHashMap<String, io.github.ibuildthecloud.gdapi.model.Action>();
        if (clz == null) {
            return result;
        }
        Actions actions = clz.getAnnotation(Actions.class);
        if (actions == null) {
            return result;
        }
        for (Action action : actions.value()) {
            if (action.collection() != collection) continue;
            String input = null;
            String output = null;
            input = StringUtils.isBlank((CharSequence)action.inputType()) ? this.getSchemaName(action.input()) : action.inputType();
            output = StringUtils.isBlank((CharSequence)action.outputType()) ? this.getSchemaName(action.output()) : action.outputType();
            result.put(action.name(), new io.github.ibuildthecloud.gdapi.model.Action(input, output));
        }
        return result;
    }

    protected SchemaImpl schemaFromObject(Object obj) {
        Class<?> clz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
        SchemaImpl schema = new SchemaImpl();
        SchemaType schemaType = obj instanceof String ? this.schemaTypeFromString((String)obj) : this.schemaTypeFromClass(clz);
        schema.setName(schemaType.name);
        schema.setPluralName(schemaType.pluralName);
        schema.setParent(schemaType.parent);
        if (schemaType.parent == null && schemaType.parentClass != null) {
            this.parentClasses.put(schema, schemaType.parentClass);
        }
        return schema;
    }

    protected SchemaType schemaTypeFromClass(Class<?> clz) {
        SchemaType schemaType = new SchemaType();
        Type type = clz.getAnnotation(Type.class);
        if (type == null) {
            type = this.defaultType;
        }
        schemaType.name = !StringUtils.isEmpty((CharSequence)type.name()) ? type.name() : StringUtils.uncapitalize((String)clz.getSimpleName());
        if (!StringUtils.isBlank((CharSequence)type.pluralName())) {
            schemaType.pluralName = type.pluralName();
        }
        if (!StringUtils.isBlank((CharSequence)type.parent())) {
            schemaType.parent = type.parent();
        }
        if (type.parentClass() != Void.class) {
            schemaType.parentClass = type.parentClass();
        }
        return schemaType;
    }

    protected SchemaType schemaTypeFromString(String type) {
        SchemaType schemaType = new SchemaType();
        String[] parts = type.split("\\s*,\\s*");
        schemaType.name = parts[0];
        for (int i = 1; i < parts.length; ++i) {
            String[] kv = parts[i].split("\\s*=\\s*");
            if (kv.length != 2) {
                throw new IllegalArgumentException("Illegal type format [" + type + "] must be comma separated key=value pairs");
            }
            String key = kv[0];
            String value = kv[1];
            if ("pluralName".equals(key)) {
                schemaType.pluralName = value;
                continue;
            }
            if (!"parent".equals(key)) continue;
            schemaType.parent = value;
        }
        return schemaType;
    }

    protected SchemaImpl readSchema(String name) {
        Type type;
        SchemaImpl schema;
        Class<Object> clz = this.typeToClass.get(name);
        if (clz == null) {
            clz = Object.class;
        }
        if ((schema = this.schemasByName.get(name)) == null) {
            schema = this.schemaFromObject(clz);
        }
        if ((type = clz.getAnnotation(Type.class)) == null) {
            type = this.defaultType;
        }
        if (type == this.defaultType) {
            schema.setCreate(this.writableByDefault);
            schema.setUpdate(this.writableByDefault);
            schema.setDeletable(this.writableByDefault);
        } else {
            schema.setCreate(type.create());
            schema.setUpdate(type.update());
            schema.setDeletable(type.delete());
        }
        schema.setById(type.byId());
        schema.setList(type.list());
        return schema;
    }

    protected Map<String, io.github.ibuildthecloud.gdapi.model.Field> sortFields(List<io.github.ibuildthecloud.gdapi.model.Field> fields) {
        TreeMap<Integer, io.github.ibuildthecloud.gdapi.model.Field> indexed = new TreeMap<Integer, io.github.ibuildthecloud.gdapi.model.Field>();
        TreeMap<String, io.github.ibuildthecloud.gdapi.model.Field> named = new TreeMap<String, io.github.ibuildthecloud.gdapi.model.Field>();
        LinkedHashMap<String, io.github.ibuildthecloud.gdapi.model.Field> result = new LinkedHashMap<String, io.github.ibuildthecloud.gdapi.model.Field>();
        for (io.github.ibuildthecloud.gdapi.model.Field field : fields) {
            Integer displayIndex = field.getDisplayIndex();
            if (displayIndex == null) {
                named.put(field.getName(), field);
                continue;
            }
            indexed.put(displayIndex, field);
        }
        for (io.github.ibuildthecloud.gdapi.model.Field field : indexed.values()) {
            result.put(field.getName(), field);
        }
        for (io.github.ibuildthecloud.gdapi.model.Field field : named.values()) {
            result.put(field.getName(), field);
        }
        return result;
    }

    protected List<io.github.ibuildthecloud.gdapi.model.Field> getFields(Class<?> clz) {
        ArrayList<io.github.ibuildthecloud.gdapi.model.Field> result = new ArrayList<io.github.ibuildthecloud.gdapi.model.Field>();
        if (clz == null) {
            return result;
        }
        for (PropertyDescriptor prop : PropertyUtils.getPropertyDescriptors(clz)) {
            FieldImpl field = this.getField(clz, prop);
            if (field == null) continue;
            result.add(field);
        }
        return result;
    }

    protected FieldImpl getField(Class<?> clz, PropertyDescriptor prop) {
        FieldImpl field = new FieldImpl();
        Method readMethod = prop.getReadMethod();
        Method writeMethod = prop.getWriteMethod();
        if (readMethod == null && writeMethod == null) {
            return null;
        }
        Field f = this.getFieldAnnotation(prop);
        if (!f.include()) {
            return null;
        }
        field.setReadMethod(readMethod);
        if (readMethod != null && readMethod.getDeclaringClass() != clz) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)f.name())) {
            field.setName(prop.getName());
        } else {
            field.setName(f.name());
        }
        if (f.displayIndex() > 0) {
            field.setDisplayIndex(f.displayIndex());
        }
        if (readMethod == null) {
            field.setIncludeInList(false);
        }
        this.assignSimpleProps(field, f);
        this.assignType(prop, field, f);
        this.assignLengths(field, f);
        this.assignOptions(prop, field, f);
        return field;
    }

    protected void assignOptions(PropertyDescriptor prop, FieldImpl field, Field f) {
        Class<?> clz = prop.getPropertyType();
        if (!clz.isEnum()) {
            return;
        }
        ArrayList<String> options = new ArrayList<String>(clz.getEnumConstants().length);
        for (Object o : clz.getEnumConstants()) {
            options.add(o.toString());
        }
        field.setOptions(options);
    }

    protected void assignSimpleProps(FieldImpl field, Field f) {
        if (!StringUtils.isEmpty((CharSequence)f.defaultValue())) {
            field.setDefault(f.defaultValue());
        }
        if (!StringUtils.isEmpty((CharSequence)f.validChars())) {
            field.setValidChars(f.validChars());
        }
        if (!StringUtils.isEmpty((CharSequence)f.invalidChars())) {
            field.setInvalidChars(f.invalidChars());
        }
        if (f == this.defaultField) {
            field.setNullable(this.writableByDefault);
            field.setUpdate(this.writableByDefault);
            field.setCreate(this.writableByDefault);
        } else {
            field.setNullable(f.nullable());
            field.setUpdate(f.update());
            field.setCreate(f.create());
        }
        field.setUnique(f.unique());
        field.setRequired(f.required());
    }

    protected void assignLengths(FieldImpl field, Field f) {
        if (f.min() != Long.MIN_VALUE) {
            field.setMin(f.min());
        }
        if (f.max() != Long.MAX_VALUE) {
            field.setMax(f.max());
        }
        if (f.minLength() != Long.MIN_VALUE) {
            field.setMinLength(f.minLength());
        }
        if (f.maxLength() != Long.MAX_VALUE) {
            field.setMaxLength(f.maxLength());
        }
    }

    protected void assignType(PropertyDescriptor prop, FieldImpl field, Field f) {
        if (f.type() != FieldType.NONE) {
            field.setTypeEnum(f.type());
            return;
        }
        if (!StringUtils.isEmpty((CharSequence)f.typeString())) {
            field.setType(f.typeString());
            return;
        }
        if (f.password()) {
            field.setTypeEnum(FieldType.PASSWORD);
            return;
        }
        this.assignSimpleType(prop.getPropertyType(), field);
        ArrayList<FieldType.TypeAndName> types = new ArrayList<FieldType.TypeAndName>();
        Method readMethod = prop.getReadMethod();
        if (readMethod != null) {
            this.getTypes(readMethod.getGenericReturnType(), types);
        }
        if (types.size() == 1) {
            field.setType(((FieldType.TypeAndName)types.get(0)).getName());
        } else if (types.size() > 1) {
            types.remove(0);
            field.setSubTypesList(types);
        }
    }

    protected void getTypes(java.lang.reflect.Type type, List<FieldType.TypeAndName> types) {
        java.lang.reflect.Type rawType;
        Class clz = null;
        if (type instanceof Class) {
            clz = (Class)type;
        }
        if (type instanceof ParameterizedType && (rawType = ((ParameterizedType)type).getRawType()) instanceof Class) {
            clz = (Class)rawType;
        }
        if (clz == null) {
            throw new IllegalArgumentException("Failed to find class for type [" + type + "]");
        }
        FieldType fieldType = this.assignSimpleType(clz, null);
        String name = fieldType.getExternalType();
        if (fieldType == FieldType.TYPE) {
            Schema subSchema = this.getSchema(clz);
            if (subSchema == null) {
                fieldType = FieldType.JSON;
                name = fieldType.getExternalType();
            } else {
                name = subSchema.getId();
            }
        }
        types.add(new FieldType.TypeAndName(fieldType, name));
        java.lang.reflect.Type subType = null;
        switch (fieldType) {
            case ARRAY: {
                if (clz.isArray()) {
                    subType = clz.getComponentType();
                    break;
                }
                subType = this.getGenericType(type, 0);
                break;
            }
            case MAP: {
                subType = this.getGenericType(type, 1);
                break;
            }
            case REFERENCE: {
                subType = this.getGenericType(type, 0);
                break;
            }
            case TYPE: {
                return;
            }
        }
        if (subType != null) {
            this.getTypes(subType, types);
        }
    }

    protected java.lang.reflect.Type getGenericType(java.lang.reflect.Type t, int index) {
        if (t instanceof ParameterizedType && ((ParameterizedType)t).getActualTypeArguments().length == index + 1) {
            return ((ParameterizedType)t).getActualTypeArguments()[index];
        }
        return Object.class;
    }

    protected FieldType assignSimpleType(Class<?> clzType, FieldImpl field) {
        FieldType result = null;
        if (clzType.isEnum()) {
            result = FieldType.ENUM;
        } else {
            block0: for (FieldType type : FieldType.values()) {
                Class<?>[] clzs = type.getClasses();
                if (clzs == null) continue;
                for (Class<?> clz : clzs) {
                    if (!clz.isAssignableFrom(clzType)) continue;
                    result = type;
                    if (!Number.class.isAssignableFrom(clzType) && !Boolean.class.isAssignableFrom(clzType) || clz.isPrimitive() || field == null) break block0;
                    field.setNullable(true);
                    break block0;
                }
            }
        }
        if (field != null) {
            field.setTypeEnum(result);
        }
        return result;
    }

    protected Field getFieldAnnotation(PropertyDescriptor prop) {
        Method readMethod = prop.getReadMethod();
        Method writeMethod = prop.getWriteMethod();
        Field f = null;
        if (readMethod != null) {
            f = readMethod.getAnnotation(Field.class);
        }
        if (f == null && writeMethod != null) {
            f = writeMethod.getAnnotation(Field.class);
        }
        if (f == null) {
            f = this.defaultField;
        }
        return f;
    }

    @PostConstruct
    public void init() {
        if (this.includeDefaultTypes) {
            this.registerSchema(Schema.class);
            this.registerSchema(ApiVersion.class);
            this.registerSchema(ApiError.class);
            this.registerSchema(Collection.class);
            this.registerSchema(Resource.class);
        }
        for (Class<?> clz : this.types) {
            this.registerSchema(clz);
        }
        for (String name : this.typeNames) {
            this.registerSchema(name);
        }
        for (Schema schema : this.schemasList) {
            this.parseSchema(schema.getId());
        }
    }

    @Override
    public List<Schema> listSchemas() {
        return this.schemasList;
    }

    @Override
    public Schema getSchema(String type) {
        return this.schemasByName.get(this.lower(type));
    }

    @Override
    public Class<?> getSchemaClass(String type) {
        return this.typeToClass.get(this.lower(type));
    }

    protected String lower(String type) {
        return type == null ? "" : type.toLowerCase();
    }

    public List<Class<?>> getTypes() {
        return this.types;
    }

    public void setTypes(List<Class<?>> types) {
        this.types = types;
    }

    public List<SchemaPostProcessor> getPostProcessors() {
        return this.postProcessors;
    }

    public void setPostProcessors(List<SchemaPostProcessor> postProcessors) {
        this.postProcessors = postProcessors;
    }

    public List<String> getTypeNames() {
        return this.typeNames;
    }

    public void setTypeNames(List<String> typeNames) {
        this.typeNames = typeNames;
    }

    public boolean isIncludeDefaultTypes() {
        return this.includeDefaultTypes;
    }

    public void setIncludeDefaultTypes(boolean includeDefaultTypes) {
        this.includeDefaultTypes = includeDefaultTypes;
    }

    public boolean isWritableByDefault() {
        return this.writableByDefault;
    }

    public void setWritableByDefault(boolean writableByDefault) {
        this.writableByDefault = writableByDefault;
    }

    public void setId(String id) {
        this.id = id;
    }

    private static final class SchemaType {
        String name;
        String pluralName;
        String parent;
        Class<?> parentClass;

        private SchemaType() {
        }
    }
}

