/*
 * Decompiled with CFR 0.152.
 */
package io.gorules.zen.loader;

import io.gorules.zen.loader.DecisionLoader;
import io.gorules.zen_engine.JsonBuffer;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public class ClasspathDecisionLoader
implements DecisionLoader {
    private final String rootPath;
    private final boolean useCache;
    private final ConcurrentHashMap<String, JsonBuffer> cache;

    public ClasspathDecisionLoader(String rootPath) {
        this(rootPath, true);
    }

    public ClasspathDecisionLoader(String rootPath, boolean useCache) {
        Object normalized = rootPath;
        if (((String)normalized).startsWith("/")) {
            normalized = ((String)normalized).substring(1);
        }
        if (!((String)normalized).isEmpty() && !((String)normalized).endsWith("/")) {
            normalized = (String)normalized + "/";
        }
        this.rootPath = normalized;
        this.useCache = useCache;
        this.cache = useCache ? new ConcurrentHashMap() : null;
    }

    @Override
    public CompletableFuture<JsonBuffer> load(String key) {
        return CompletableFuture.supplyAsync(() -> {
            if (this.useCache && this.cache.containsKey(key)) {
                return this.cache.get(key);
            }
            try {
                String resourcePath = this.rootPath + key;
                InputStream is = this.getClass().getClassLoader().getResourceAsStream(resourcePath);
                if (is == null) {
                    throw new RuntimeException("Decision not found in classpath: " + resourcePath);
                }
                byte[] content = is.readAllBytes();
                is.close();
                JsonBuffer buffer = new JsonBuffer(content);
                if (this.useCache) {
                    this.cache.put(key, buffer);
                }
                return buffer;
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to load decision from classpath: " + key, e);
            }
        });
    }

    public void clearCache() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    public void evict(String key) {
        if (this.cache != null) {
            this.cache.remove(key);
        }
    }
}

