/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.util;

import io.jbock.util.Either;
import io.jbock.util.LeftOptional;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

final class Left<L, R>
extends Either<L, R> {
    private final L value;

    private Left(L value) {
        this.value = Objects.requireNonNull(value);
    }

    static <L, R> Left<L, R> create(L value) {
        return new Left<L, R>(value);
    }

    @Override
    public LeftOptional<L> getLeft() {
        return LeftOptional.of(this.value);
    }

    @Override
    public boolean isLeft() {
        return true;
    }

    @Override
    public Optional<R> getRight() {
        return Optional.empty();
    }

    @Override
    public <X extends Throwable> R orElseThrow(Function<? super L, ? extends X> f) throws X {
        throw (Throwable)f.apply(this.value);
    }

    @Override
    public <U> U fold(Function<? super L, ? extends U> leftMapper, Function<? super R, ? extends U> rightMapper) {
        return leftMapper.apply(this.value);
    }

    @Override
    public String toString() {
        return String.format("Left[%s]", this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Left)) {
            return false;
        }
        Left other = (Left)obj;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }
}

