/*
 * Decompiled with CFR 0.152.
 */
package io.jbock.util;

import io.jbock.util.Either;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public final class LeftOptional<T> {
    private static final LeftOptional<?> EMPTY = new LeftOptional(Optional.empty());
    private final Optional<T> value;

    private LeftOptional(Optional<T> value) {
        this.value = value;
    }

    public static <T> LeftOptional<T> empty() {
        LeftOptional<?> t = EMPTY;
        return t;
    }

    private LeftOptional(T value) {
        this.value = Optional.of(value);
    }

    public static <T> LeftOptional<T> of(T value) {
        return new LeftOptional<Optional<T>>(Optional.of(value));
    }

    public static <T> LeftOptional<T> ofNullable(T value) {
        return value == null ? EMPTY : new LeftOptional<T>(value);
    }

    public T get() {
        return this.value.get();
    }

    public boolean isPresent() {
        return this.value.isPresent();
    }

    public boolean isEmpty() {
        return this.value.isEmpty();
    }

    public void ifPresent(Consumer<? super T> action) {
        this.value.ifPresent(action);
    }

    public void ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
        this.value.ifPresentOrElse(action, emptyAction);
    }

    public LeftOptional<T> filter(Predicate<? super T> predicate) {
        return this.value.filter(predicate).map(LeftOptional::of).orElse(LeftOptional.empty());
    }

    public <U> LeftOptional<U> map(Function<? super T, ? extends U> mapper) {
        return this.value.map(mapper).map(LeftOptional::of).orElse(LeftOptional.empty());
    }

    public <U> LeftOptional<U> flatMap(Function<? super T, ? extends LeftOptional<? extends U>> mapper) {
        return this.value.flatMap((? super T t) -> {
            Optional result;
            Optional narrowed = result = ((LeftOptional)mapper.apply(t)).map(Optional::of).orElse(Optional.empty());
            return narrowed;
        }).map(LeftOptional::of).orElse(LeftOptional.empty());
    }

    public LeftOptional<T> or(Supplier<? extends LeftOptional<? extends T>> supplier) {
        return this.value.or(() -> {
            Optional result;
            Optional narrowed = result = ((LeftOptional)supplier.get()).map(Optional::of).orElse(Optional.empty());
            return narrowed;
        }).map(LeftOptional::of).orElse(LeftOptional.empty());
    }

    public Stream<T> stream() {
        return this.value.stream();
    }

    public T orElse(T other) {
        return this.value.orElse(other);
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        return this.value.orElseGet(supplier);
    }

    public T orElseThrow() {
        return this.value.orElseThrow();
    }

    public <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return this.value.orElseThrow(exceptionSupplier);
    }

    public <R> Either<T, R> orElseRight(Supplier<? extends R> supplier) {
        return this.value.map(Either::left).orElseGet(() -> Either.right(supplier.get()));
    }

    public <R> Either<T, R> flatMapRight(Supplier<? extends Either<? extends T, ? extends R>> supplier) {
        return this.value.map(Either::left).orElseGet(() -> {
            Either result = (Either)supplier.get();
            return Either.narrow(result);
        });
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LeftOptional)) {
            return false;
        }
        LeftOptional other = (LeftOptional)obj;
        return this.value.equals(other.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return this.value.map(v -> String.format("LeftOptional[%s]", v)).orElse("LeftOptional.empty");
    }
}

