/*
 * Decompiled with CFR 0.152.
 */
package io.github.julwas797.esaapi.api.handler;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.stream.Collectors;
import org.json.JSONArray;
import org.json.JSONObject;

public class APIHandler {
    private static final APIHandler INSTANCE = new APIHandler();

    private APIHandler() {
    }

    public static APIHandler getInstance() {
        return INSTANCE;
    }

    public JSONArray getJsonApiDataArray(String source) {
        if (source == null) {
            return null;
        }
        JSONObject formattedApiData = new JSONObject(source);
        return formattedApiData.optJSONArray("smog_data");
    }

    public JSONArray getJsonApiDataArray() {
        return this.getJsonApiDataArray(this.getRawJsonData());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getRawJsonData() {
        try (BufferedReader apiReader = this.getReader();){
            String string = apiReader.lines().collect(Collectors.joining());
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader(new URL("https://public-esa.ose.gov.pl/api/v1/smog").openStream()));
    }
}

