/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.ChatImageCode;

import com.google.common.collect.Lists;
import io.github.kituin.ChatImageCode.ChatImageFrame;
import io.github.kituin.ChatImageCode.ChatImageUrl;
import io.github.kituin.ChatImageCode.exception.InvalidChatImageCodeException;
import io.github.kituin.ChatImageCode.exception.InvalidChatImageUrlException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ChatImageCode {
    public static final Pattern pattern = Pattern.compile("\\[\\[CICode,(.+)\\]\\]");
    public static final Pattern cicodesPattern = Pattern.compile("(\\[\\[CICode,(.*?)\\]\\])");
    public static final Pattern cqPattern = Pattern.compile("\\[CQ:image,(.*?)\\]");
    public static final Pattern uriPattern = Pattern.compile("(https?:\\/\\/|file:\\/\\/\\/)([^:<>\\\"]*\\/)([^:<>\\\"]*)\\.(png!thumbnail|bmp|jpe?g|gif)");
    public static HashMap<String, ChatImageFrame> CACHE_MAP = new HashMap();
    public static HashMap<String, Integer> NSFW_MAP = new HashMap();
    private ChatImageUrl url = null;
    private boolean nsfw = false;
    private final boolean isSelf;
    private final long timestamp;
    private String name = "codename.chatimage.default";
    public static TimeoutHelper timeoutHelper;
    public static LogHelper logHelper;

    ChatImageCode(boolean isSelf) {
        this.isSelf = isSelf;
        this.timestamp = System.currentTimeMillis();
    }

    public ChatImageCode(String url) throws InvalidChatImageUrlException {
        this(new ChatImageUrl(url), null, false);
    }

    public ChatImageCode(String url, String name) throws InvalidChatImageUrlException {
        this(new ChatImageUrl(url), name, false);
    }

    public ChatImageCode(ChatImageUrl url, String name, boolean isSelf) {
        this.url = url;
        if (name != null) {
            this.name = name;
        }
        this.timestamp = System.currentTimeMillis();
        this.isSelf = isSelf;
    }

    public static ChatImageCode of(String code) throws InvalidChatImageCodeException {
        return ChatImageCode.of(code, false);
    }

    public static ChatImageCode of(String code, boolean self) throws InvalidChatImageCodeException {
        ChatImageCode chatImageCode = new ChatImageCode(self);
        chatImageCode.match(code);
        return chatImageCode;
    }

    public ChatImageFrame getFrame() {
        if (this.url == null) {
            return new ChatImageFrame(ChatImageFrame.FrameError.ILLEGAL_CICODE_ERROR);
        }
        String useUrl = this.url.getUrl();
        if (CACHE_MAP.containsKey(useUrl)) {
            return CACHE_MAP.get(useUrl);
        }
        return new ChatImageFrame(ChatImageFrame.FrameError.ID_NOT_FOUND);
    }

    public static List<Object> sliceMsg(String checkedText, boolean isSelf, Consumer<InvalidChatImageCodeException> logger) {
        Matcher m = cicodesPattern.matcher(checkedText);
        ArrayList res = Lists.newArrayList();
        int lastPosition = 0;
        while (m.find()) {
            try {
                ChatImageCode image = ChatImageCode.of(m.group(), isSelf);
                if (m.start() != 0) {
                    res.add(checkedText.substring(lastPosition, m.start()));
                }
                lastPosition = m.end();
                res.add(image);
            }
            catch (InvalidChatImageCodeException e) {
                logger.accept(e);
            }
        }
        if (lastPosition != checkedText.length()) {
            res.add(checkedText.substring(lastPosition));
        }
        return res;
    }

    public static String checkCQCode(String checkedText) {
        Matcher cqm = cqPattern.matcher((CharSequence)checkedText);
        while (cqm.find()) {
            String[] cqArgs = cqm.group(1).split(",");
            String cq_Url = "";
            for (int i = 0; i < cqArgs.length; ++i) {
                String[] cqParams = cqArgs[i].split("=");
                if (!"url".equals(cqParams[0])) continue;
                cq_Url = cqParams[1];
                break;
            }
            if (cq_Url.isEmpty()) continue;
            checkedText = ((String)checkedText).substring(0, cqm.start()) + String.format("[[CICode,url=%s]]", cq_Url) + ((String)checkedText).substring(cqm.end());
        }
        return checkedText;
    }

    public static String checkImageUri(String checkedText) {
        Matcher matcher = uriPattern.matcher((CharSequence)checkedText);
        while (matcher.find()) {
            String url = matcher.group();
            if (url.isEmpty()) continue;
            checkedText = ((String)checkedText).substring(0, matcher.start()) + String.format("[[CICode,url=%s]]", url) + ((String)checkedText).substring(matcher.end());
        }
        return checkedText;
    }

    private void match(String originalCode) throws InvalidChatImageCodeException {
        Matcher matcher = pattern.matcher(originalCode);
        if (!matcher.find()) {
            throw new InvalidChatImageCodeException(originalCode + "<-can not find any String to ChatImageCode, Please Recheck");
        }
        this.slice(matcher.group(1));
    }

    private void slice(String rawCode) throws InvalidChatImageCodeException {
        String[] raws;
        for (String raw : raws = rawCode.split(",")) {
            String[] temps = raw.split("=", 2);
            if (temps.length == 2) {
                String value = temps[0].trim();
                if (value.equals("url")) {
                    try {
                        this.url = new ChatImageUrl(temps[1].trim());
                        continue;
                    }
                    catch (InvalidChatImageUrlException e) {
                        throw new InvalidChatImageCodeException(e.getMessage(), e.getMode());
                    }
                }
                if (value.equals("nsfw")) {
                    this.nsfw = Boolean.parseBoolean(temps[1].trim());
                    continue;
                }
                if (!value.equals("name")) continue;
                this.name = temps[1].trim();
                continue;
            }
            throw new InvalidChatImageCodeException(raw + "<-can not match the value of ChatImageCode, Please Recheck");
        }
        if (this.url == null) {
            throw new InvalidChatImageCodeException("not match url in ChatImageCode, Please Recheck");
        }
    }

    public String getOriginalUrl() {
        return this.url.getOriginalUrl();
    }

    public ChatImageUrl getChatImageUrl() {
        return this.url;
    }

    public boolean getNsfw() {
        return this.nsfw;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[[CICode,url=").append(this.url.getOriginalUrl());
        if (this.nsfw) {
            sb.append(",nsfw=true");
        }
        if (this.name != null) {
            sb.append(",name=").append(this.name);
        }
        return sb.append("]]").toString();
    }

    public String getName() {
        return this.name;
    }

    public boolean isSendFromSelf() {
        return this.isSelf;
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() > this.timestamp + 1000L * (long)timeoutHelper.getTimeOut();
    }

    @FunctionalInterface
    public static interface LogHelper {
        public void Log();
    }

    @FunctionalInterface
    public static interface TimeoutHelper {
        public int getTimeOut();
    }

    public static enum ChatImageType {
        GIF,
        PNG,
        ICO,
        WEBP;

    }
}

