/*
 * Decompiled with CFR 0.152.
 */
package io.github.kituin.ChatImageCode;

import chatimage.okhttp3.Call;
import chatimage.okhttp3.Callback;
import chatimage.okhttp3.OkHttpClient;
import chatimage.okhttp3.Request;
import chatimage.okhttp3.Response;
import chatimage.okhttp3.ResponseBody;
import io.github.kituin.ChatImageCode.ChatImageCodeInstance;
import io.github.kituin.ChatImageCode.ChatImageFrame;
import io.github.kituin.ChatImageCode.ClientStorage;
import io.github.kituin.ChatImageCode.FileImageHandler;
import io.github.kituin.ChatImageCode.Http.IProgressListener;
import io.github.kituin.ChatImageCode.Http.ProgressResponseBody;
import java.io.IOException;
import java.util.HashMap;

public class HttpImageHandler {
    public static HashMap<String, Integer> HTTPS_MAP = new HashMap();

    public static boolean request(final String url) {
        Request getRequest;
        try {
            getRequest = new Request.Builder().url(url).addHeader("User-Agent", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/121.0.0.0 Safari/537.36 Edg/121.0.0.0").get().build();
        }
        catch (IllegalArgumentException ep) {
            return false;
        }
        if (HTTPS_MAP.containsKey(url) && HTTPS_MAP.get(url) == 1) {
            return true;
        }
        HTTPS_MAP.put(url, 1);
        ChatImageCodeInstance.LOGGER.debug("[HttpImageHandler][GET] {}", url);
        IProgressListener listener = (bytesRead, contentLength, done) -> {
            int percent = (int)(100L * bytesRead / contentLength);
            if (percent >= 0) {
                ClientStorage.URL_PROGRESS.put(url, percent);
            }
        };
        OkHttpClient client = new OkHttpClient.Builder().addNetworkInterceptor(chain -> {
            Response response = chain.proceed(chain.request());
            return response.newBuilder().body(new ProgressResponseBody(response.body(), listener)).build();
        }).addInterceptor(chain -> {
            Response response = chain.proceed(chain.request());
            if (response.body() != null && response.body().contentLength() > (long)ChatImageCodeInstance.CLIENT_ADAPTER.getMaxFileSize() * 1000L) {
                throw new IOException("File size is too large");
            }
            return response;
        }).build();
        client.newCall(getRequest).enqueue(new Callback(){

            @Override
            public void onFailure(Call call, IOException e) {
                HTTPS_MAP.put(url, 2);
                ChatImageCodeInstance.LOGGER.error("{} Error-> {}", url, e);
                ClientStorage.AddImageError(url, ChatImageFrame.FrameError.TIMEOUT);
            }

            @Override
            public void onResponse(Call call, Response response) {
                ResponseBody body = response.body();
                if (body != null) {
                    try {
                        FileImageHandler.loadFile(body.bytes(), url);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                HTTPS_MAP.put(url, 2);
            }
        });
        return true;
    }
}

