/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.spt.impls;

import io.github.kloping.spt.PartUtils;
import io.github.kloping.spt.annotations.Constructor;
import io.github.kloping.spt.annotations.Param;
import io.github.kloping.spt.interfaces.Logger;
import io.github.kloping.spt.interfaces.component.ContextManager;
import io.github.kloping.spt.interfaces.component.InstanceCrater;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Arrays;

public class InstanceCraterImpl
implements InstanceCrater {
    @Override
    public <T> T create(Class<T> cla, ContextManager contextManager) {
        java.lang.reflect.Constructor<?>[] constructors = this.getConstructors(cla);
        T t = null;
        for (java.lang.reflect.Constructor<?> con : constructors) {
            try {
                con.setAccessible(true);
                Parameter[] parameters = con.getParameters();
                if (parameters.length == 0) {
                    t = (T)con.newInstance(new Object[0]);
                    break;
                }
                Object[] args = new Object[parameters.length];
                int index = 0;
                for (Parameter parameter : parameters) {
                    String id = null;
                    if (parameter.isAnnotationPresent(Param.class)) {
                        Param p = parameter.getDeclaredAnnotation(Param.class);
                        id = p.value();
                    }
                    args[index++] = contextManager.getContextEntity(parameter.getType(), id);
                }
                t = (T)con.newInstance(args);
                break;
            }
            catch (InvocationTargetException ex) {
                Throwable e = ex.getTargetException();
                Logger logger = contextManager.getContextEntity(Logger.class);
                if (e instanceof RuntimeException) {
                    String msg = e.getMessage() + " at create bean " + cla.getSimpleName() + " parameters " + Arrays.toString(con.getParameters());
                    if (logger != null) {
                        logger.error(msg);
                    } else {
                        System.err.println(msg);
                    }
                    Constructor constructor = con.getDeclaredAnnotation(Constructor.class);
                    if (constructor == null || constructor.value() == 0) continue;
                    break;
                }
                if (logger != null) {
                    logger.error(PartUtils.getExceptionLine(e));
                    continue;
                }
                e.printStackTrace();
            }
            catch (IllegalAccessException | InstantiationException e) {
                Logger logger = contextManager.getContextEntity(Logger.class);
                if (logger != null) {
                    logger.error(PartUtils.getExceptionLine(e));
                    continue;
                }
                e.printStackTrace();
            }
        }
        return t;
    }

    private <T> java.lang.reflect.Constructor<?>[] getConstructors(Class<T> cla) {
        java.lang.reflect.Constructor<?>[] constructors;
        boolean k = true;
        for (java.lang.reflect.Constructor<?> constructor : constructors = cla.getDeclaredConstructors()) {
            constructor.setAccessible(true);
            if (!constructor.isAnnotationPresent(Constructor.class)) continue;
            k = false;
        }
        if (k) {
            return constructors;
        }
        ArrayList list = new ArrayList();
        for (java.lang.reflect.Constructor<?> constructor : constructors) {
            if (!constructor.isAnnotationPresent(Constructor.class)) continue;
            list.add(constructor);
        }
        return list.toArray(new java.lang.reflect.Constructor[0]);
    }
}

