/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.entities.qqpd.message;

import com.alibaba.fastjson.annotation.JSONField;
import io.github.kloping.qqbot.api.DeleteAble;
import io.github.kloping.qqbot.api.Reactive;
import io.github.kloping.qqbot.api.SendAble;
import io.github.kloping.qqbot.api.SenderAndCidMidGetter;
import io.github.kloping.qqbot.api.message.Pinsble;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.entities.qqpd.Channel;
import io.github.kloping.qqbot.entities.qqpd.Member;
import io.github.kloping.qqbot.entities.qqpd.PinsMessage;
import io.github.kloping.qqbot.entities.qqpd.User;
import io.github.kloping.qqbot.entities.qqpd.data.Emoji;
import io.github.kloping.qqbot.entities.qqpd.message.MessageAttachment;
import io.github.kloping.qqbot.entities.qqpd.message.MessageReference;
import io.github.kloping.qqbot.entities.qqpd.message.RawPreMessage;
import io.github.kloping.qqbot.http.data.ActionResult;
import io.github.kloping.qqbot.impl.MessagePacket;
import io.github.kloping.qqbot.utils.BaseUtils;
import java.util.Arrays;

public class RawMessage
implements SenderAndCidMidGetter,
DeleteAble,
Reactive,
Pinsble {
    private String id;
    private String channelId;
    private String guildId;
    private String content;
    private String timestamp;
    private String editedTimestamp;
    private Boolean mentionEveryone;
    private User author;
    private MessageAttachment[] attachments;
    private Object embed;
    private User[] mentions;
    private Member member;
    private Object ark;
    private Integer seq;
    private String seqInChannel;
    private MessageReference messageReference;
    private String srcGuildId;
    @JSONField(serialize=false, deserialize=false)
    private Bot bot;

    @Override
    public ActionResult send(String text, RawMessage message) {
        return this.send(new MessagePacket().setContent(text).setReplyId(message.id));
    }

    @Override
    public ActionResult send(String text) {
        return this.send(new MessagePacket().setContent(text));
    }

    @Override
    public ActionResult send(MessagePacket packet) {
        RawPreMessage msg = new RawPreMessage();
        msg.setMsgId(this.id);
        BaseUtils.packet2pre(packet, msg);
        return this.bot.messageBase.send(this.channelId, msg, Channel.SEND_MESSAGE_HEADERS);
    }

    @Override
    public ActionResult send(RawPreMessage msg) {
        return this.bot.messageBase.send(this.channelId, msg, Channel.SEND_MESSAGE_HEADERS);
    }

    @Override
    public Object delete() {
        return this.bot.messageBase.delete(this.channelId, this.id, false);
    }

    public String getContent() {
        return this.content;
    }

    @Override
    public ActionResult send(SendAble msg) {
        return msg.send(this);
    }

    @Override
    public String getCid() {
        return this.getChannelId();
    }

    @Override
    public String getMid() {
        return this.getId();
    }

    @Override
    public void addEmoji(Emoji emoji) {
        this.bot.channelBase.addEmoji(this.getChannelId(), this.getMid(), emoji.getType(), emoji.getId().toString());
    }

    @Override
    public void removeEmoji(Emoji emoji) {
        this.bot.channelBase.removeEmoji(this.getChannelId(), this.getMid(), emoji.getType(), emoji.getId().toString());
    }

    @Override
    public Bot getBot() {
        return this.bot;
    }

    @Override
    public void setBot(Bot bot) {
        this.bot = bot;
    }

    @Override
    public PinsMessage addPins() {
        PinsMessage pm = new PinsMessage();
        String p0 = this.getBot().channelBase.addPins(this.getChannelId(), this.getMid());
        block10: for (String s : p0.split("&")) {
            String[] kv = s.split("=");
            String key = kv[0];
            String value = kv[1];
            switch (key) {
                case "channel_id": {
                    pm.setChannel_id(value);
                    continue block10;
                }
                case "guild_id": {
                    pm.setGuild_id(value);
                    continue block10;
                }
                case "message_ids": {
                    pm.getMessage_ids().add(value);
                }
            }
        }
        return pm;
    }

    @Override
    public void deletePins() {
        this.getBot().channelBase.deletePins(this.getChannelId(), this.getMid());
    }

    @Override
    public PinsMessage getPins() {
        return this.getBot().channelBase.getPins(this.getChannelId());
    }

    public String getId() {
        return this.id;
    }

    public String getChannelId() {
        return this.channelId;
    }

    public String getGuildId() {
        return this.guildId;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public String getEditedTimestamp() {
        return this.editedTimestamp;
    }

    public Boolean getMentionEveryone() {
        return this.mentionEveryone;
    }

    public User getAuthor() {
        return this.author;
    }

    public MessageAttachment[] getAttachments() {
        return this.attachments;
    }

    public Object getEmbed() {
        return this.embed;
    }

    public User[] getMentions() {
        return this.mentions;
    }

    public Member getMember() {
        return this.member;
    }

    public Object getArk() {
        return this.ark;
    }

    public Integer getSeq() {
        return this.seq;
    }

    public String getSeqInChannel() {
        return this.seqInChannel;
    }

    public MessageReference getMessageReference() {
        return this.messageReference;
    }

    public String getSrcGuildId() {
        return this.srcGuildId;
    }

    public RawMessage setId(String id) {
        this.id = id;
        return this;
    }

    public RawMessage setChannelId(String channelId) {
        this.channelId = channelId;
        return this;
    }

    public RawMessage setGuildId(String guildId) {
        this.guildId = guildId;
        return this;
    }

    public RawMessage setContent(String content) {
        this.content = content;
        return this;
    }

    public RawMessage setTimestamp(String timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public RawMessage setEditedTimestamp(String editedTimestamp) {
        this.editedTimestamp = editedTimestamp;
        return this;
    }

    public RawMessage setMentionEveryone(Boolean mentionEveryone) {
        this.mentionEveryone = mentionEveryone;
        return this;
    }

    public RawMessage setAuthor(User author) {
        this.author = author;
        return this;
    }

    public RawMessage setAttachments(MessageAttachment[] attachments) {
        this.attachments = attachments;
        return this;
    }

    public RawMessage setEmbed(Object embed) {
        this.embed = embed;
        return this;
    }

    public RawMessage setMentions(User[] mentions) {
        this.mentions = mentions;
        return this;
    }

    public RawMessage setMember(Member member) {
        this.member = member;
        return this;
    }

    public RawMessage setArk(Object ark) {
        this.ark = ark;
        return this;
    }

    public RawMessage setSeq(Integer seq) {
        this.seq = seq;
        return this;
    }

    public RawMessage setSeqInChannel(String seqInChannel) {
        this.seqInChannel = seqInChannel;
        return this;
    }

    public RawMessage setMessageReference(MessageReference messageReference) {
        this.messageReference = messageReference;
        return this;
    }

    public RawMessage setSrcGuildId(String srcGuildId) {
        this.srcGuildId = srcGuildId;
        return this;
    }

    public String toString() {
        return "RawMessage(id=" + this.getId() + ", channelId=" + this.getChannelId() + ", guildId=" + this.getGuildId() + ", content=" + this.getContent() + ", timestamp=" + this.getTimestamp() + ", editedTimestamp=" + this.getEditedTimestamp() + ", mentionEveryone=" + this.getMentionEveryone() + ", author=" + this.getAuthor() + ", attachments=" + Arrays.deepToString(this.getAttachments()) + ", embed=" + this.getEmbed() + ", mentions=" + Arrays.deepToString(this.getMentions()) + ", member=" + this.getMember() + ", ark=" + this.getArk() + ", seq=" + this.getSeq() + ", seqInChannel=" + this.getSeqInChannel() + ", messageReference=" + this.getMessageReference() + ", srcGuildId=" + this.getSrcGuildId() + ", bot=" + this.getBot() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RawMessage)) {
            return false;
        }
        RawMessage other = (RawMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$mentionEveryone = this.getMentionEveryone();
        Boolean other$mentionEveryone = other.getMentionEveryone();
        if (this$mentionEveryone == null ? other$mentionEveryone != null : !((Object)this$mentionEveryone).equals(other$mentionEveryone)) {
            return false;
        }
        Integer this$seq = this.getSeq();
        Integer other$seq = other.getSeq();
        if (this$seq == null ? other$seq != null : !((Object)this$seq).equals(other$seq)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$channelId = this.getChannelId();
        String other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !this$channelId.equals(other$channelId)) {
            return false;
        }
        String this$guildId = this.getGuildId();
        String other$guildId = other.getGuildId();
        if (this$guildId == null ? other$guildId != null : !this$guildId.equals(other$guildId)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$timestamp = this.getTimestamp();
        String other$timestamp = other.getTimestamp();
        if (this$timestamp == null ? other$timestamp != null : !this$timestamp.equals(other$timestamp)) {
            return false;
        }
        String this$editedTimestamp = this.getEditedTimestamp();
        String other$editedTimestamp = other.getEditedTimestamp();
        if (this$editedTimestamp == null ? other$editedTimestamp != null : !this$editedTimestamp.equals(other$editedTimestamp)) {
            return false;
        }
        User this$author = this.getAuthor();
        User other$author = other.getAuthor();
        if (this$author == null ? other$author != null : !((Object)this$author).equals(other$author)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getAttachments(), other.getAttachments())) {
            return false;
        }
        Object this$embed = this.getEmbed();
        Object other$embed = other.getEmbed();
        if (this$embed == null ? other$embed != null : !this$embed.equals(other$embed)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMentions(), other.getMentions())) {
            return false;
        }
        Member this$member = this.getMember();
        Member other$member = other.getMember();
        if (this$member == null ? other$member != null : !((Object)this$member).equals(other$member)) {
            return false;
        }
        Object this$ark = this.getArk();
        Object other$ark = other.getArk();
        if (this$ark == null ? other$ark != null : !this$ark.equals(other$ark)) {
            return false;
        }
        String this$seqInChannel = this.getSeqInChannel();
        String other$seqInChannel = other.getSeqInChannel();
        if (this$seqInChannel == null ? other$seqInChannel != null : !this$seqInChannel.equals(other$seqInChannel)) {
            return false;
        }
        MessageReference this$messageReference = this.getMessageReference();
        MessageReference other$messageReference = other.getMessageReference();
        if (this$messageReference == null ? other$messageReference != null : !((Object)this$messageReference).equals(other$messageReference)) {
            return false;
        }
        String this$srcGuildId = this.getSrcGuildId();
        String other$srcGuildId = other.getSrcGuildId();
        if (this$srcGuildId == null ? other$srcGuildId != null : !this$srcGuildId.equals(other$srcGuildId)) {
            return false;
        }
        Bot this$bot = this.getBot();
        Bot other$bot = other.getBot();
        return !(this$bot == null ? other$bot != null : !this$bot.equals(other$bot));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RawMessage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $mentionEveryone = this.getMentionEveryone();
        result = result * 59 + ($mentionEveryone == null ? 43 : ((Object)$mentionEveryone).hashCode());
        Integer $seq = this.getSeq();
        result = result * 59 + ($seq == null ? 43 : ((Object)$seq).hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : $channelId.hashCode());
        String $guildId = this.getGuildId();
        result = result * 59 + ($guildId == null ? 43 : $guildId.hashCode());
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $timestamp = this.getTimestamp();
        result = result * 59 + ($timestamp == null ? 43 : $timestamp.hashCode());
        String $editedTimestamp = this.getEditedTimestamp();
        result = result * 59 + ($editedTimestamp == null ? 43 : $editedTimestamp.hashCode());
        User $author = this.getAuthor();
        result = result * 59 + ($author == null ? 43 : ((Object)$author).hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getAttachments());
        Object $embed = this.getEmbed();
        result = result * 59 + ($embed == null ? 43 : $embed.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getMentions());
        Member $member = this.getMember();
        result = result * 59 + ($member == null ? 43 : ((Object)$member).hashCode());
        Object $ark = this.getArk();
        result = result * 59 + ($ark == null ? 43 : $ark.hashCode());
        String $seqInChannel = this.getSeqInChannel();
        result = result * 59 + ($seqInChannel == null ? 43 : $seqInChannel.hashCode());
        MessageReference $messageReference = this.getMessageReference();
        result = result * 59 + ($messageReference == null ? 43 : ((Object)$messageReference).hashCode());
        String $srcGuildId = this.getSrcGuildId();
        result = result * 59 + ($srcGuildId == null ? 43 : $srcGuildId.hashCode());
        Bot $bot = this.getBot();
        result = result * 59 + ($bot == null ? 43 : $bot.hashCode());
        return result;
    }
}

