/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.network;

import io.github.kloping.MySpringTool.annotations.AutoStand;
import io.github.kloping.MySpringTool.annotations.Entity;
import io.github.kloping.MySpringTool.interfaces.Logger;
import io.github.kloping.MySpringTool.interfaces.component.ContextManager;
import io.github.kloping.qqbot.Resource;
import io.github.kloping.qqbot.Starter;
import io.github.kloping.qqbot.entities.Pack;
import io.github.kloping.qqbot.http.BotBase;
import io.github.kloping.qqbot.interfaces.OnCloseListener;
import io.github.kloping.qqbot.interfaces.OnPackReceive;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.NotYetConnectedException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

@Entity
public class WssWorker
implements Runnable {
    @AutoStand
    private ContextManager contextManager;
    @AutoStand
    private BotBase botBase;
    @AutoStand
    private Logger logger;
    public WebSocketClient webSocket;
    protected Integer msgr = 0;
    protected Integer msgs = 0;
    protected URI uri;
    @AutoStand
    Starter.Config config;
    public List<OnCloseListener> closeListeners = new ArrayList<OnCloseListener>();
    public List<OnPackReceive> onPackReceives = new LinkedList<OnPackReceive>();

    @Override
    public void run() {
        try {
            try {
                if (this.uri == null) {
                    this.uri = new URI(this.botBase.gateway().getUrl());
                }
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            this.logger.log("ws url:" + this.uri);
            if (this.webSocket != null && !this.webSocket.isClosed()) {
                this.webSocket.close();
            }
            this.webSocket = new WebSocketClient(this.uri){

                public void onOpen(ServerHandshake serverHandshake) {
                    WssWorker.this.logger.info("wss opened");
                }

                public void onMessage(String s) {
                    Pack pack = (Pack)Resource.GSON.fromJson(s, Pack.class);
                    WssWorker.this.logger.log(String.format("receive %s", s));
                    if (pack == null) {
                        WssWorker.this.logger.error(String.format("message pack parse error (%s)", s));
                    } else {
                        for (OnPackReceive onPackReceive : WssWorker.this.onPackReceives) {
                            if (onPackReceive.onReceive(pack)) break;
                        }
                    }
                    Integer n = WssWorker.this.msgr;
                    Integer n2 = WssWorker.this.msgr = Integer.valueOf(WssWorker.this.msgr + 1);
                }

                public void send(String text) throws NotYetConnectedException {
                    super.send(text);
                    WssWorker.this.logger.log("wss send: " + text);
                    Integer n = WssWorker.this.msgs;
                    Integer n2 = WssWorker.this.msgs = Integer.valueOf(WssWorker.this.msgs + 1);
                }

                public void onClose(int i, String s, boolean b) {
                    WssWorker.this.logger.waring("wss closed with code " + i + " " + s);
                    for (OnCloseListener onCloseListener : WssWorker.this.closeListeners) {
                        onCloseListener.onClose(i, WssWorker.this.webSocket);
                    }
                }

                public void onError(Exception e) {
                    WssWorker.this.logger.error("wss error");
                    e.printStackTrace();
                }
            };
            this.webSocket.setConnectionLostTimeout(120);
            this.webSocket.run();
        }
        catch (Exception e) {
            this.logger.error("\u5728WebSocketClient\u542f\u52a8\u65f6\u5931\u8d25");
            e.printStackTrace();
            if (!this.config.getReconnect().booleanValue()) {
                return;
            }
            try {
                TimeUnit.SECONDS.sleep(10L);
            }
            catch (InterruptedException ex) {
                e.printStackTrace();
            }
            this.run();
        }
    }

    public Boolean getReconnect() {
        Boolean k = (Boolean)this.contextManager.getContextEntity(Boolean.class, "is_reconnect");
        return k == null ? false : k;
    }

    public List<OnCloseListener> getCloseListeners() {
        return this.closeListeners;
    }

    public List<OnPackReceive> getOnPackReceives() {
        return this.onPackReceives;
    }

    public void close() {
    }
}

