/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.entities.ex.msg;

import io.github.kloping.object.ObjectUtils;
import io.github.kloping.qqbot.api.SendAble;
import io.github.kloping.qqbot.api.SenderAndCidMidGetter;
import io.github.kloping.qqbot.entities.ex.At;
import io.github.kloping.qqbot.entities.ex.AtAll;
import io.github.kloping.qqbot.entities.ex.Image;
import io.github.kloping.qqbot.entities.ex.MessagePreBuilder;
import io.github.kloping.qqbot.entities.ex.PlainText;
import io.github.kloping.qqbot.entities.qqpd.data.Emoji;
import io.github.kloping.qqbot.http.data.ActionResult;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Consumer;

public class MessageChain
implements SendAble {
    public List<SendAble> list = new LinkedList<SendAble>();

    @Override
    public ActionResult send(SenderAndCidMidGetter er) {
        MessagePreBuilder builder = new MessagePreBuilder();
        boolean flag0 = false;
        for (SendAble sendAble : this.list) {
            if (sendAble instanceof PlainText) {
                builder.append(sendAble.toString());
                continue;
            }
            if (sendAble instanceof Image) {
                if (!flag0) {
                    builder.append((Image)sendAble);
                    flag0 = true;
                    continue;
                }
                er.send(builder.build());
                builder.clear();
                builder.append((Image)sendAble);
                continue;
            }
            if (sendAble instanceof At) {
                builder.append((At)sendAble);
                continue;
            }
            if (sendAble instanceof AtAll) {
                builder.append((AtAll)sendAble);
                continue;
            }
            if (!(sendAble instanceof Emoji)) continue;
            builder.append((Emoji)sendAble);
        }
        return er.send(builder.build());
    }

    public void forEach(Consumer<? super SendAble> consumer) {
        for (SendAble data : this.list) {
            consumer.accept(data);
        }
    }

    public MessageChain append(SendAble sendAble) {
        if (sendAble != null) {
            this.list.add(sendAble);
        }
        return this;
    }

    private void append(SendAble sendAble, MessagePreBuilder builder) {
        if (sendAble instanceof At) {
            builder.append((At)sendAble);
        } else if (sendAble instanceof AtAll) {
            builder.append((AtAll)sendAble);
        } else if (sendAble instanceof Image) {
            builder.append((Image)sendAble);
        } else if (sendAble instanceof PlainText) {
            builder.append(((PlainText)sendAble).getText());
        } else if (sendAble instanceof Emoji) {
            builder.append((Emoji)sendAble);
        }
    }

    public int size() {
        return this.list.size();
    }

    public SendAble get(int index) {
        return this.list.get(index);
    }

    public boolean isType(int index, Class<? extends SendAble> cla) {
        return ObjectUtils.isSuperOrInterface(cla, this.list.get(index).getClass());
    }

    public String toString() {
        return this.list.toString();
    }
}

