/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.utils;

import io.github.kloping.arr.ArrDeSerializer;
import io.github.kloping.judge.Judge;
import io.github.kloping.number.NumberUtils;
import io.github.kloping.qqbot.api.SendAble;
import io.github.kloping.qqbot.entities.ex.At;
import io.github.kloping.qqbot.entities.ex.AtAll;
import io.github.kloping.qqbot.entities.ex.Image;
import io.github.kloping.qqbot.entities.ex.PlainText;
import io.github.kloping.qqbot.entities.ex.msg.MessageChain;
import io.github.kloping.qqbot.entities.qqpd.data.Emoji;
import io.github.kloping.qqbot.entities.qqpd.message.MessageAttachment;
import io.github.kloping.qqbot.entities.qqpd.message.MessageReference;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.entities.qqpd.message.RawPreMessage;
import io.github.kloping.qqbot.impl.MessagePacket;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class BaseUtils {
    public static final Pattern AT_PATTERN = Pattern.compile("<@![0-9]+>");
    public static final Pattern AT_ALL = Pattern.compile("@everyone");
    public static final Pattern AT_CHANNEL = Pattern.compile("<#[0-9]+>");
    public static final Pattern EMOJI = Pattern.compile("<emoji:[0-9]+>");
    public static final ArrDeSerializer<SendAble> DE_SERIALIZER = new ArrDeSerializer();

    public static void packet2pre(MessagePacket packet, RawPreMessage msg) {
        if (Judge.isNotEmpty((String)packet.getContent())) {
            msg.setContent(packet.getContent());
        }
        if (Judge.isNotEmpty((String)packet.getImage())) {
            msg.setImage(packet.getImage());
        }
        if (Judge.isNotEmpty((String)packet.getImage())) {
            msg.setImage(packet.getImage());
        }
        if (Judge.isNotEmpty((String)packet.getReplyId())) {
            msg.setMessageReference(new MessageReference(packet.getReplyId()));
        }
    }

    public static <T, K1, K2> T tryGet(Map<K1, Map<K2, T>> tmap, K1 k1, K2 k2) {
        Map<K2, T> map = tmap.get(k1);
        if (map == null) {
            return null;
        }
        return map.get(k2);
    }

    public static MessageChain parseToMessageChain(RawMessage rawMessage) {
        String content = rawMessage.getContent();
        MessageChain chain = new MessageChain();
        BaseUtils.dispose(content, chain);
        if (rawMessage.getAttachments() != null) {
            for (MessageAttachment attachment : rawMessage.getAttachments()) {
                chain.append(new Image(attachment.getUrl()));
            }
        }
        return chain;
    }

    private static void dispose(String content, MessageChain chain) {
        if (Judge.isEmpty((String)content)) {
            return;
        }
        List sendAbles = DE_SERIALIZER.deserializer(content);
        if (sendAbles == null || sendAbles.isEmpty()) {
            return;
        }
        for (SendAble sendAble : sendAbles) {
            chain.append(sendAble);
        }
    }

    static {
        DE_SERIALIZER.add(AT_PATTERN, (ArrDeSerializer.Rule0)new ArrDeSerializer.Rule0<At>(){

            public At deserializer(String s) {
                return new At("member", NumberUtils.findNumberFromString((String)s));
            }
        });
        DE_SERIALIZER.add(AT_ALL, (ArrDeSerializer.Rule0)new ArrDeSerializer.Rule0<AtAll>(){

            public AtAll deserializer(String s) {
                return new AtAll();
            }
        });
        DE_SERIALIZER.add(AT_CHANNEL, (ArrDeSerializer.Rule0)new ArrDeSerializer.Rule0<At>(){

            public At deserializer(String s) {
                return new At("channel", NumberUtils.findNumberFromString((String)s));
            }
        });
        DE_SERIALIZER.add(EMOJI, (ArrDeSerializer.Rule0)new ArrDeSerializer.Rule0<Emoji>(){

            public Emoji deserializer(String s) {
                return Emoji.valueOf(Integer.valueOf(NumberUtils.findNumberFromString((String)s)));
            }
        });
        DE_SERIALIZER.add(ArrDeSerializer.EMPTY_PATTERN, (ArrDeSerializer.Rule0)new ArrDeSerializer.Rule0<PlainText>(){

            public PlainText deserializer(String s) {
                return new PlainText(s);
            }
        });
    }
}

