/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.impl;

import com.alibaba.fastjson.JSONObject;
import io.github.kloping.qqbot.api.SendAble;
import io.github.kloping.qqbot.api.event.InterActionEvent;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.entities.qqpd.InterAction;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.http.data.Result;

public class BaseInterActionEvent
implements InterActionEvent {
    private JSONObject metaData;
    private InterAction interAction;

    public BaseInterActionEvent(Bot bot, JSONObject metaData) {
        this.interAction = (InterAction)metaData.toJavaObject(InterAction.class);
        this.interAction.setBot(bot);
    }

    @Override
    public Result send(String text) {
        return this.getInterAction().send(text);
    }

    @Override
    public Result send(String text, RawMessage message) {
        return this.getInterAction().send(text, message);
    }

    @Override
    public Result send(SendAble msg) {
        return this.getInterAction().send(msg);
    }

    @Override
    public JSONObject getMetadata() {
        return this.metaData;
    }

    @Override
    public Bot getBot() {
        return this.getInterAction().getBot();
    }

    @Override
    public Integer getChatType() {
        return this.getInterAction().getChat_type();
    }

    @Override
    public InterAction getInterAction() {
        return this.interAction;
    }

    @Override
    public void response(int code) {
        this.getBot().interActionBase.response(this.getInterAction().getId(), String.format("{\"code\": %s}", code));
    }

    public String toString() {
        return String.format("InterActionEvent [button %s(%s)] from %s", this.getInterAction().getData().getResolved().getButton_data(), this.getInterAction().getData().getResolved().getButton_id(), this.getInterAction().getCid());
    }
}

