/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.impl.message;

import com.alibaba.fastjson.JSONObject;
import io.github.kloping.qqbot.api.event.ChannelEvent;
import io.github.kloping.qqbot.api.message.MessageChannelReceiveEvent;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.entities.ex.enums.EnvType;
import io.github.kloping.qqbot.entities.qqpd.data.Emoji;
import io.github.kloping.qqbot.entities.qqpd.message.RawMessage;
import io.github.kloping.qqbot.impl.message.BaseMessageEvent;

public class BaseMessageChannelReceiveEvent
extends BaseMessageEvent
implements ChannelEvent,
MessageChannelReceiveEvent {
    protected String content;
    protected String channelId;

    public BaseMessageChannelReceiveEvent(RawMessage message, JSONObject jo, Bot bot) {
        super(message, jo, bot);
        this.channel = this.getGuild().getChannel(message.getChannelId());
        this.sender = this.getGuild().getMember(message.getAuthor().getId());
        this.channelId = this.getChannel().getId();
    }

    @Override
    public String getContent() {
        return this.content == null ? (this.content = this.getMessage().toString()) : this.content;
    }

    @Override
    public String getChannelId() {
        return this.channelId;
    }

    @Override
    public String toString() {
        return String.format("[type(%s) %s].%s member(%s)=>%s", EnvType.GUILD.name(), this.getGuild().getName(), this.getChannel().getName(), this.getSender().getNick(), this.getRawMessage().toString0());
    }

    @Override
    public void addEmoji(Emoji emoji) {
        this.getRawMessage().addEmoji(emoji);
    }

    @Override
    public void removeEmoji(Emoji emoji) {
        this.getRawMessage().addEmoji(emoji);
    }

    @Override
    public String getClassName() {
        return MessageChannelReceiveEvent.class.getSimpleName();
    }
}

