/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.utils;

import io.github.kloping.spt.interfaces.Logger;
import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.fusesource.jansi.Ansi;

public class LoggerImpl
implements Logger {
    public static final LoggerImpl INSTANCE = new LoggerImpl();
    public static final Color NORMAL_LOW_COLOR = new Color(116, 117, 116, 224);
    public static final Color NORMAL_COLOR = new Color(202, 206, 199, 247);
    public static final Color INFO_COLOR = new Color(24, 220, 85, 247);
    public static final Color DEBUG_COLOR = new Color(234, 213, 103, 247);
    public static final Color ERROR_COLOR = new Color(224, 17, 106, 247);
    private int logLevel = 0;
    private SimpleDateFormat df = new SimpleDateFormat("MM/dd-HH:mm:ss:SSS");
    private String prefix = "[github.kloping.ST]";
    public DateFormat difference = new SimpleDateFormat("dd");
    public DateFormat dfn = new SimpleDateFormat("/yyyy-MM-dd");
    public String logFileDir = "./logs/%s.log";
    private File file;
    private String updd = null;
    private BufferedWriter writer = null;

    public synchronized File getFile() {
        String dd = this.difference.format(new Date());
        if (this.updd == null) {
            this.updd = dd;
        } else if (!this.updd.equals(dd)) {
            this.step0();
            this.setWriter(this.file);
        }
        if (this.file == null) {
            this.step0();
        }
        this.updd = dd;
        return this.file;
    }

    private void step0() {
        this.file = new File(String.format(this.logFileDir, this.dfn.format(new Date())));
    }

    public void setOutFile(String path) {
        this.logFileDir = path;
    }

    public void setFormat(SimpleDateFormat format) {
        this.df = format;
    }

    public void Log(String mess, Integer level) {
        String out;
        block22: {
            String log;
            block21: {
                log = null;
                out = null;
                try {
                    log = "[" + this.df.format(new Date()) + "]=>" + mess;
                    switch (level) {
                        case 0: {
                            log = "[Normal]" + log;
                            break;
                        }
                        case 1: {
                            log = "[Info]  " + log;
                            break;
                        }
                        case 2: {
                            log = "[Debug] " + log;
                            break;
                        }
                        case -1: {
                            log = "[Error] " + log;
                            break;
                        }
                    }
                    log = this.prefix + log;
                    out = null;
                    if (level == 0) {
                        out = Ansi.ansi().fgRgb(NORMAL_COLOR.getRGB()).a(log).reset().toString();
                    } else if (level == 1) {
                        out = Ansi.ansi().fgRgb(INFO_COLOR.getRGB()).a(log).reset().toString();
                    } else if (level == 2) {
                        out = Ansi.ansi().fgRgb(DEBUG_COLOR.getRGB()).a(log).reset().toString();
                    } else if (level == -1) {
                        out = Ansi.ansi().fgRgb(ERROR_COLOR.getRGB()).a(log).reset().toString();
                    }
                }
                catch (Exception e) {
                    if (level != -1 && level < this.logLevel) break block21;
                    e.printStackTrace();
                }
            }
            if (this.logFileDir != null) {
                try {
                    BufferedWriter writer = this.getWriter();
                    if (writer == null) break block22;
                    try {
                        log = log.replaceAll("\\\u001b\\[38\\;2\\;[0-9]+\\;[0-9]+\\;[0-9]+m", "").replaceAll("\\\u001b\\[m", "");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    writer.write(log);
                    writer.newLine();
                    writer.flush();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (level != -1 && level < this.logLevel) {
            return;
        }
        System.out.println(out);
    }

    private BufferedWriter getWriter() {
        File f0 = this.getFile();
        if (f0 != null && this.writer == null) {
            this.setWriter(f0);
        }
        return this.writer;
    }

    private void setWriter(File f0) {
        try {
            if (this.writer != null) {
                this.writer.close();
            }
            this.writer = new BufferedWriter(new FileWriter(f0, true));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int setLogLevel(int level) {
        this.logLevel = level;
        return this.logLevel;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }
}

