/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.entities.ex;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import io.github.kloping.qqbot.api.SendAble;
import io.github.kloping.qqbot.api.SenderAndCidMidGetter;
import io.github.kloping.qqbot.entities.ex.enums.EnvType;
import io.github.kloping.qqbot.entities.qqpd.Channel;
import io.github.kloping.qqbot.entities.qqpd.message.RawPreMessage;
import io.github.kloping.qqbot.http.data.ActionResult;
import io.github.kloping.qqbot.http.data.Result;
import io.github.kloping.qqbot.http.data.V2MsgData;
import io.github.kloping.qqbot.http.data.V2Result;
import java.util.LinkedList;
import java.util.List;

public class Keyboard
implements SendAble {
    private String id = null;
    private JSONObject content;

    public Keyboard(String id) {
        this.id = id;
    }

    private Keyboard() {
    }

    @Override
    public Result send(SenderAndCidMidGetter er) {
        if (this.id != null) {
            er.getBot().logger.error("keyboard id is not null.");
            return null;
        }
        if (er.getEnvType() == EnvType.GROUP) {
            V2MsgData v2MsgData = new V2MsgData();
            v2MsgData.setMsg_type(2);
            v2MsgData.setKeyboard(this);
            v2MsgData.setMsg_id(er.getMid());
            String d0 = JSON.toJSONString((Object)v2MsgData);
            return new Result<V2Result>(er.getBot().groupBaseV2.send(er.getCid(), d0, Channel.SEND_MESSAGE_HEADERS));
        }
        if (er.getEnvType() == EnvType.GUILD) {
            RawPreMessage preMessage = new RawPreMessage();
            preMessage.setMsgId(er.getMid());
            return new Result<ActionResult>(er.getBot().messageBase.send(er.getCid(), preMessage, Channel.SEND_MESSAGE_HEADERS));
        }
        return er.send(this);
    }

    public String getId() {
        return this.id;
    }

    public JSONObject getContent() {
        return this.content;
    }

    public static class Permission {
        private String[] specify_role_ids = new String[0];
        private String[] specify_user_ids = new String[0];
        private Integer type = 2;

        public Permission() {
        }

        public Permission(String[] specify_role_ids, String[] specify_user_ids, Integer type2) {
            this.specify_role_ids = specify_role_ids;
            this.specify_user_ids = specify_user_ids;
            this.type = type2;
        }

        public String[] getSpecify_role_ids() {
            return this.specify_role_ids;
        }

        public String[] getSpecify_user_ids() {
            return this.specify_user_ids;
        }

        public Integer getType() {
            return this.type;
        }
    }

    public static class Action {
        private String data = "\u6309\u94ae";
        private Integer type = 2;
        private Permission permission = new Permission();
        private String unsupport_tips = "\u5ba2\u6237\u7aef\u7248\u672c\u8fc7\u4f4e";
        private Boolean reply = false;
        private Boolean enter = false;

        public String getData() {
            return this.data;
        }

        public Integer getType() {
            return this.type;
        }

        public Permission getPermission() {
            return this.permission;
        }

        public String getUnsupport_tips() {
            return this.unsupport_tips;
        }

        public Boolean getReply() {
            return this.reply;
        }

        public Boolean getEnter() {
            return this.enter;
        }
    }

    public static class RenderData {
        private String label;
        private String visited_label;
        private Integer style = 1;

        public String getLabel() {
            return this.label;
        }

        public String getVisited_label() {
            return this.visited_label;
        }

        public Integer getStyle() {
            return this.style;
        }
    }

    public static class Button {
        private RenderData render_data = new RenderData();
        private Action action = new Action();
        private String id;

        public RenderData getRender_data() {
            return this.render_data;
        }

        public Action getAction() {
            return this.action;
        }

        public String getId() {
            return this.id;
        }
    }

    public static class Buttons {
        private List<Button> buttons = new LinkedList<Button>();

        public List<Button> getButtons() {
            return this.buttons;
        }
    }

    public static class ButtonBuilder {
        private RowBuilder builder;
        private Button button;

        public ButtonBuilder(RowBuilder builder) {
            this.builder = builder;
            this.button = new Button();
            this.button.id = builder.builder.requestIdIndex().toString();
        }

        public ButtonBuilder setLabel(String text) {
            this.button.render_data.label = text;
            return this;
        }

        public ButtonBuilder setVisitedLabel(String text) {
            this.button.render_data.visited_label = text;
            return this;
        }

        public ButtonBuilder setStyle(Integer style) {
            this.button.render_data.style = style;
            return this;
        }

        public ButtonBuilder setActionData(String data) {
            this.button.action.data = data;
            return this;
        }

        public ButtonBuilder setActionType(Integer type2) {
            this.button.action.type = type2;
            return this;
        }

        public ButtonBuilder setActionEnter(boolean enter) {
            this.button.action.enter = enter;
            return this;
        }

        public ButtonBuilder setActionReply(boolean reply) {
            this.button.action.reply = reply;
            return this;
        }

        public ButtonBuilder setUnSupportTips(String tips) {
            this.button.action.unsupport_tips = tips;
            return this;
        }

        public ButtonBuilder setPermissionType(Integer type2) {
            this.button.action.permission.type = type2;
            return this;
        }

        public ButtonBuilder setPermission(Permission permission) {
            this.button.action.permission = permission;
            return this;
        }

        public RowBuilder build() {
            this.builder.buttons.buttons.add(this.button);
            return this.builder;
        }
    }

    public static class RowBuilder {
        private KeyboardBuilder builder;
        private Buttons buttons = new Buttons();

        public RowBuilder(KeyboardBuilder builder) {
            this.builder = builder;
        }

        public ButtonBuilder addButton() {
            return new ButtonBuilder(this);
        }

        public RowBuilder addButton(Button button) {
            this.buttons.buttons.add(button);
            return this;
        }

        public KeyboardBuilder build() {
            this.builder.list.add(this.buttons);
            return this.builder;
        }
    }

    public static class KeyboardBuilder {
        private Integer id = 1;
        private List list = new LinkedList();

        public static KeyboardBuilder create() {
            return new KeyboardBuilder();
        }

        private Integer requestIdIndex() {
            Integer n = this.id;
            Integer n2 = this.id = Integer.valueOf(this.id + 1);
            return n;
        }

        public RowBuilder addRow() {
            return new RowBuilder(this);
        }

        public Keyboard build() {
            Keyboard keyboard = new Keyboard();
            JSONObject rows = new JSONObject();
            rows.put("rows", (Object)JSONArray.parseArray((String)JSON.toJSONString((Object)this.list)));
            keyboard.content = rows;
            return keyboard;
        }
    }
}

