/*
 * Decompiled with CFR 0.152.
 */
package io.github.kloping.qqbot.entities.qqpd;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.annotation.JSONField;
import io.github.kloping.map.MapUtils;
import io.github.kloping.qqbot.api.BotContent;
import io.github.kloping.qqbot.api.OpAble;
import io.github.kloping.qqbot.api.SessionCreator;
import io.github.kloping.qqbot.entities.Bot;
import io.github.kloping.qqbot.entities.ex.ChannelData;
import io.github.kloping.qqbot.entities.qqpd.Channel;
import io.github.kloping.qqbot.entities.qqpd.Common;
import io.github.kloping.qqbot.entities.qqpd.Dms;
import io.github.kloping.qqbot.entities.qqpd.DmsRequest;
import io.github.kloping.qqbot.entities.qqpd.Member;
import io.github.kloping.qqbot.entities.qqpd.MemberWithGuildID;
import io.github.kloping.qqbot.utils.BaseUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Guild
implements SessionCreator,
OpAble,
BotContent {
    private Boolean owner;
    private String joinedAt;
    private String ownerId;
    private String name;
    private String icon;
    private Integer maxMembers;
    private String description;
    private String id;
    private Integer memberCount;
    private String opUserId;
    @JSONField(serialize=false, deserialize=false)
    private Bot bot;

    @Override
    public Dms create(String uid) {
        if (this.getMember(uid) == null) {
            return null;
        }
        DmsRequest request = new DmsRequest();
        request.setSourceGuildId(this.id);
        request.setRecipientId(uid);
        return this.bot.dmsBase.create(request, Channel.SEND_MESSAGE_HEADERS);
    }

    public MemberWithGuildID getMemberWithGuildId(String userId) {
        Member member = this.getMember(userId);
        JSONObject jo = JSON.parseObject((String)JSON.toJSONString((Object)member));
        jo.put("guildId", (Object)this.getId());
        MemberWithGuildID w = (MemberWithGuildID)jo.toJavaObject(MemberWithGuildID.class);
        w.setBot(this.getBot());
        member.setGuild(this);
        w.setGuild(this);
        return w;
    }

    public Member getMember(String userId) {
        Member member = null;
        member = BaseUtils.tryGet(Common.GUILD_MEMBER_TEMP, this.getId(), userId);
        if (member == null) {
            member = this.bot.guildBase.getMember(this.getId(), userId);
            member.setGuild(this);
            if (member == null || member.getNick() == null || member.getRoles() == null || member.getUser() == null) {
                return null;
            }
            MapUtils.append(Common.GUILD_MEMBER_TEMP, (Object)this.getId(), (Object)userId, (Object)member);
        }
        return member;
    }

    public Member setMember(Member member) {
        String uid = member.getUser().getId();
        Member m0 = this.getMember(uid);
        if (m0 == null) {
            m0 = member;
        }
        member.setGuild(this);
        MapUtils.append(Common.GUILD_MEMBER_TEMP, (Object)this.getId(), (Object)uid, (Object)member);
        return m0;
    }

    private synchronized void channelInit() {
        if (!Common.GUILD_CHANNEL_TEMP.containsKey(this.id)) {
            HashMap<String, Channel> map = new HashMap<String, Channel>();
            Channel[] channels = this.bot.guildBase.getChannels(this.id);
            if (channels == null || channels.length == 0) {
                throw new RuntimeException(String.format("Guild(%s) channels list Initialization failed", this.getName()));
            }
            for (Channel channel : channels) {
                map.put(channel.getId(), channel);
            }
            Common.GUILD_CHANNEL_TEMP.put(this.id, map);
        }
    }

    public List<Channel> channels() {
        if (!Common.GUILD_CHANNEL_TEMP.containsKey(this.id)) {
            this.channelInit();
        }
        return new ArrayList<Channel>(Common.GUILD_CHANNEL_TEMP.get(this.id).values());
    }

    public Map<String, Channel> channelMap() {
        if (!Common.GUILD_CHANNEL_TEMP.containsKey(this.id)) {
            this.channelInit();
        }
        return Common.GUILD_CHANNEL_TEMP.get(this.id);
    }

    public Channel getChannel(String cid) {
        Map<String, Channel> cm = null;
        cm = Common.GUILD_CHANNEL_TEMP.getOrDefault(this.id, Common.EMPTY_CHANNEL_MAP);
        if (cm.containsKey(cid)) {
            return cm.get(cid);
        }
        Channel channel = this.getBot().channelBase.getChannel(cid);
        MapUtils.append(Common.GUILD_CHANNEL_TEMP, (Object)this.getId(), (Object)cid, (Object)channel, HashMap.class);
        return channel;
    }

    @Override
    public void setBot(Bot bot) {
        this.bot = bot;
    }

    public Channel create(ChannelData data) {
        Channel channel = this.getBot().guildBase.create(Channel.SEND_MESSAGE_HEADERS, this.getId(), data);
        return channel;
    }

    public Boolean getOwner() {
        return this.owner;
    }

    public String getJoinedAt() {
        return this.joinedAt;
    }

    public String getOwnerId() {
        return this.ownerId;
    }

    public String getName() {
        return this.name;
    }

    public String getIcon() {
        return this.icon;
    }

    public Integer getMaxMembers() {
        return this.maxMembers;
    }

    public String getDescription() {
        return this.description;
    }

    public Integer getMemberCount() {
        return this.memberCount;
    }

    @Override
    public String getOpUserId() {
        return this.opUserId;
    }

    public Guild setOwner(Boolean owner) {
        this.owner = owner;
        return this;
    }

    public Guild setJoinedAt(String joinedAt) {
        this.joinedAt = joinedAt;
        return this;
    }

    public Guild setOwnerId(String ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    public Guild setName(String name) {
        this.name = name;
        return this;
    }

    public Guild setIcon(String icon) {
        this.icon = icon;
        return this;
    }

    public Guild setMaxMembers(Integer maxMembers) {
        this.maxMembers = maxMembers;
        return this;
    }

    public Guild setDescription(String description) {
        this.description = description;
        return this;
    }

    public Guild setId(String id) {
        this.id = id;
        return this;
    }

    public Guild setMemberCount(Integer memberCount) {
        this.memberCount = memberCount;
        return this;
    }

    public Guild setOpUserId(String opUserId) {
        this.opUserId = opUserId;
        return this;
    }

    public String toString() {
        return "Guild(owner=" + this.getOwner() + ", joinedAt=" + this.getJoinedAt() + ", ownerId=" + this.getOwnerId() + ", name=" + this.getName() + ", icon=" + this.getIcon() + ", maxMembers=" + this.getMaxMembers() + ", description=" + this.getDescription() + ", id=" + this.getId() + ", memberCount=" + this.getMemberCount() + ", opUserId=" + this.getOpUserId() + ", bot=" + this.getBot() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Guild)) {
            return false;
        }
        Guild other = (Guild)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$owner = this.getOwner();
        Boolean other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !((Object)this$owner).equals(other$owner)) {
            return false;
        }
        Integer this$maxMembers = this.getMaxMembers();
        Integer other$maxMembers = other.getMaxMembers();
        if (this$maxMembers == null ? other$maxMembers != null : !((Object)this$maxMembers).equals(other$maxMembers)) {
            return false;
        }
        Integer this$memberCount = this.getMemberCount();
        Integer other$memberCount = other.getMemberCount();
        if (this$memberCount == null ? other$memberCount != null : !((Object)this$memberCount).equals(other$memberCount)) {
            return false;
        }
        String this$joinedAt = this.getJoinedAt();
        String other$joinedAt = other.getJoinedAt();
        if (this$joinedAt == null ? other$joinedAt != null : !this$joinedAt.equals(other$joinedAt)) {
            return false;
        }
        String this$ownerId = this.getOwnerId();
        String other$ownerId = other.getOwnerId();
        if (this$ownerId == null ? other$ownerId != null : !this$ownerId.equals(other$ownerId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        if (this$icon == null ? other$icon != null : !this$icon.equals(other$icon)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$opUserId = this.getOpUserId();
        String other$opUserId = other.getOpUserId();
        if (this$opUserId == null ? other$opUserId != null : !this$opUserId.equals(other$opUserId)) {
            return false;
        }
        Bot this$bot = this.getBot();
        Bot other$bot = other.getBot();
        return !(this$bot == null ? other$bot != null : !this$bot.equals(other$bot));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Guild;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : ((Object)$owner).hashCode());
        Integer $maxMembers = this.getMaxMembers();
        result = result * 59 + ($maxMembers == null ? 43 : ((Object)$maxMembers).hashCode());
        Integer $memberCount = this.getMemberCount();
        result = result * 59 + ($memberCount == null ? 43 : ((Object)$memberCount).hashCode());
        String $joinedAt = this.getJoinedAt();
        result = result * 59 + ($joinedAt == null ? 43 : $joinedAt.hashCode());
        String $ownerId = this.getOwnerId();
        result = result * 59 + ($ownerId == null ? 43 : $ownerId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $opUserId = this.getOpUserId();
        result = result * 59 + ($opUserId == null ? 43 : $opUserId.hashCode());
        Bot $bot = this.getBot();
        result = result * 59 + ($bot == null ? 43 : $bot.hashCode());
        return result;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public Bot getBot() {
        return this.bot;
    }
}

