/*
 * Decompiled with CFR 0.152.
 */
package io.github.kscripting.kscript.cache;

import io.github.kscripting.kscript.cache.Cache;
import io.github.kscripting.kscript.creator.JarArtifact;
import io.github.kscripting.kscript.model.Content;
import io.github.kscripting.shell.model.OsPath;
import io.github.kscripting.shell.model.OsPathExtKt;
import io.github.kscripting.shell.model.ScriptType;
import java.io.File;
import java.net.URI;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J(\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00030\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\b0\fJ\"\u0010\r\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000eJ\"\u0010\u000f\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00100\u000eJ0\u0010\u0011\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\n2\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013J(\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0018\u0010\u000b\u001a\u0014\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00150\u0013R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/github/kscripting/kscript/cache/Cache;", "", "cacheBasePath", "Lio/github/kscripting/shell/model/OsPath;", "(Lio/github/kscripting/shell/model/OsPath;)V", "clear", "", "getOrCreateDependencies", "", "digest", "", "creator", "Lkotlin/Function0;", "getOrCreateIdeaProject", "Lkotlin/Function1;", "getOrCreateJar", "Lio/github/kscripting/kscript/creator/JarArtifact;", "getOrCreatePackage", "scriptName", "Lkotlin/Function2;", "getOrCreateUriItem", "Lio/github/kscripting/kscript/model/Content;", "uri", "Ljava/net/URI;", "kscript"})
public final class Cache {
    @NotNull
    private final OsPath cacheBasePath;

    public Cache(@NotNull OsPath cacheBasePath) {
        Intrinsics.checkNotNullParameter((Object)cacheBasePath, (String)"cacheBasePath");
        this.cacheBasePath = cacheBasePath;
        OsPathExtKt.createDirectories((OsPath)this.cacheBasePath);
    }

    @NotNull
    public final OsPath getOrCreateIdeaProject(@NotNull String digest, @NotNull Function1<? super OsPath, OsPath> creator) {
        OsPath osPath;
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter(creator, (String)"creator");
        String[] stringArray = new String[]{"idea_" + digest};
        OsPath path2 = this.cacheBasePath.resolve(stringArray);
        if (OsPathExtKt.exists((OsPath)path2)) {
            osPath = path2;
        } else {
            OsPathExtKt.createDirectories((OsPath)path2);
            osPath = (OsPath)creator.invoke((Object)path2);
        }
        return osPath;
    }

    @NotNull
    public final OsPath getOrCreatePackage(@NotNull String digest, @NotNull String scriptName, @NotNull Function2<? super OsPath, ? super OsPath, OsPath> creator) {
        OsPath osPath;
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter((Object)scriptName, (String)"scriptName");
        Intrinsics.checkNotNullParameter(creator, (String)"creator");
        String[] stringArray = new String[]{"package_" + digest};
        OsPath path2 = this.cacheBasePath.resolve(stringArray);
        String[] stringArray2 = new String[]{"build/libs/" + scriptName};
        OsPath cachedPackageFile = path2.resolve(stringArray2);
        if (OsPathExtKt.exists((OsPath)cachedPackageFile)) {
            osPath = cachedPackageFile;
        } else {
            OsPathExtKt.createDirectories((OsPath)path2);
            osPath = (OsPath)creator.invoke((Object)path2, (Object)cachedPackageFile);
        }
        return osPath;
    }

    @NotNull
    public final JarArtifact getOrCreateJar(@NotNull String digest, @NotNull Function1<? super OsPath, JarArtifact> creator) {
        JarArtifact jarArtifact;
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter(creator, (String)"creator");
        String[] stringArray = new String[]{"jar_" + digest};
        OsPath directory = this.cacheBasePath.resolve(stringArray);
        String[] stringArray2 = new String[]{"jarArtifact.descriptor"};
        OsPath cachedJarArtifact = directory.resolve(stringArray2);
        if (OsPathExtKt.exists((OsPath)cachedJarArtifact)) {
            List jarArtifactLines = StringsKt.lines((CharSequence)OsPathExtKt.readText$default((OsPath)cachedJarArtifact, null, (int)1, null));
            jarArtifact = new JarArtifact(OsPath.Companion.createOrThrow(OsPathExtKt.getNativeType((OsPath)this.cacheBasePath), (String)jarArtifactLines.get(0), new String[0]), (String)jarArtifactLines.get(1));
        } else {
            OsPathExtKt.createDirectories((OsPath)directory);
            JarArtifact jarArtifact2 = (JarArtifact)creator.invoke((Object)directory);
            OsPathExtKt.writeText$default((OsPath)cachedJarArtifact, (CharSequence)(jarArtifact2.getPath() + "\n" + jarArtifact2.getExecClassName()), null, (OpenOption[])new OpenOption[0], (int)2, null);
            jarArtifact = jarArtifact2;
        }
        return jarArtifact;
    }

    @NotNull
    public final Content getOrCreateUriItem(@NotNull URI uri, @NotNull Function2<? super URI, ? super OsPath, Content> creator) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intrinsics.checkNotNullParameter(creator, (String)"creator");
        String digest = DigestUtils.md5Hex((String)uri.toString());
        String[] stringArray = new String[]{"uri_" + digest};
        OsPath directory = this.cacheBasePath.resolve(stringArray);
        String[] stringArray2 = new String[]{"uri.descriptor"};
        OsPath descriptorFile = directory.resolve(stringArray2);
        String[] stringArray3 = new String[]{"uri.content"};
        OsPath contentFile = directory.resolve(stringArray3);
        if (OsPathExtKt.exists((OsPath)descriptorFile) && OsPathExtKt.exists((OsPath)contentFile)) {
            List descriptor = StringsKt.lines((CharSequence)OsPathExtKt.readText$default((OsPath)descriptorFile, null, (int)1, null));
            ScriptType scriptType = ScriptType.valueOf((String)((String)descriptor.get(0)));
            String fileName = (String)descriptor.get(1);
            URI cachedUri = URI.create((String)descriptor.get(2));
            URI contextUri = URI.create((String)descriptor.get(3));
            String content = OsPathExtKt.readText$default((OsPath)contentFile, null, (int)1, null);
            Intrinsics.checkNotNullExpressionValue((Object)cachedUri, (String)"cachedUri");
            Intrinsics.checkNotNullExpressionValue((Object)contextUri, (String)"contextUri");
            return new Content(content, scriptType, fileName, cachedUri, contextUri, contentFile);
        }
        Content content = (Content)creator.invoke((Object)uri, (Object)contentFile);
        OsPathExtKt.createDirectories((OsPath)directory);
        OsPathExtKt.writeText$default((OsPath)descriptorFile, (CharSequence)(content.getScriptType() + "\n" + content.getFileName() + "\n" + content.getUri() + "\n" + content.getContextUri()), null, (OpenOption[])new OpenOption[0], (int)2, null);
        OsPathExtKt.writeText$default((OsPath)contentFile, (CharSequence)content.getText(), null, (OpenOption[])new OpenOption[0], (int)2, null);
        return content;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<OsPath> getOrCreateDependencies(@NotNull String digest, @NotNull Function0<? extends Set<OsPath>> creator) {
        Set dependencies2;
        Intrinsics.checkNotNullParameter((Object)digest, (String)"digest");
        Intrinsics.checkNotNullParameter(creator, (String)"creator");
        String[] stringArray = new String[]{"dependencies_" + digest};
        OsPath directory = this.cacheBasePath.resolve(stringArray);
        String[] stringArray2 = new String[]{"dependencies.content"};
        OsPath contentFile = directory.resolve(stringArray2);
        if (OsPathExtKt.exists((OsPath)contentFile)) {
            boolean bl;
            block7: {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                String it;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                Iterable iterable = StringsKt.lines((CharSequence)OsPathExtKt.readText$default((OsPath)contentFile, null, (int)1, null));
                boolean $i$f$filter = false;
                Iterator iterator = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    it = (String)element$iv$iv;
                    boolean bl2 = false;
                    boolean bl3 = ((CharSequence)it).length() > 0;
                    if (!bl3) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    it = (String)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    collection.add(OsPath.Companion.createOrThrow(OsPathExtKt.getNativeType((OsPath)this.cacheBasePath), it, new String[0]));
                }
                dependencies2 = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                Iterable $this$all$iv = dependencies2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        OsPath it2 = (OsPath)element$iv;
                        boolean bl5 = false;
                        if (OsPathExtKt.exists((OsPath)it2)) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return dependencies2;
            }
        }
        dependencies2 = (Set)creator.invoke();
        OsPathExtKt.createDirectories((OsPath)directory);
        OsPathExtKt.writeText$default((OsPath)contentFile, (CharSequence)CollectionsKt.joinToString$default((Iterable)dependencies2, (CharSequence)"\n", null, null, (int)0, null, (Function1)getOrCreateDependencies.2.INSTANCE, (int)30, null), null, (OpenOption[])new OpenOption[0], (int)2, null);
        return dependencies2;
    }

    public final void clear() {
        FileUtils.cleanDirectory((File)OsPathExtKt.toNativeFile((OsPath)this.cacheBasePath));
    }
}

