/*
 * Decompiled with CFR 0.152.
 */
package io.github.kscripting.kscript.creator;

import io.github.kscripting.kscript.code.GradleTemplates;
import io.github.kscripting.kscript.code.Templates;
import io.github.kscripting.kscript.creator.JarArtifact;
import io.github.kscripting.kscript.model.Script;
import io.github.kscripting.kscript.util.Executor;
import io.github.kscripting.kscript.util.FileUtils;
import io.github.kscripting.kscript.util.Logger;
import io.github.kscripting.shell.model.OsPath;
import io.github.kscripting.shell.model.OsPathExtKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J&\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lio/github/kscripting/kscript/creator/PackageCreator;", "", "executor", "Lio/github/kscripting/kscript/util/Executor;", "(Lio/github/kscripting/kscript/util/Executor;)V", "packageKscript", "Lio/github/kscripting/shell/model/OsPath;", "basePath", "packageFile", "script", "Lio/github/kscripting/kscript/model/Script;", "jarArtifact", "Lio/github/kscripting/kscript/creator/JarArtifact;", "kscript"})
public final class PackageCreator {
    @NotNull
    private final Executor executor;

    public PackageCreator(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.executor = executor;
    }

    @NotNull
    public final OsPath packageKscript(@NotNull OsPath basePath, @NotNull OsPath packageFile, @NotNull Script script, @NotNull JarArtifact jarArtifact) {
        Intrinsics.checkNotNullParameter((Object)basePath, (String)"basePath");
        Intrinsics.checkNotNullParameter((Object)packageFile, (String)"packageFile");
        Intrinsics.checkNotNullParameter((Object)script, (String)"script");
        Intrinsics.checkNotNullParameter((Object)jarArtifact, (String)"jarArtifact");
        Logger.INSTANCE.infoMsg("Packaging script '" + script.getScriptLocation().getScriptName() + "' into standalone executable...");
        String[] stringArray = new String[]{"exec_header.sh"};
        FileUtils.INSTANCE.createFile(basePath.resolve(stringArray), Templates.INSTANCE.createExecuteHeader(script.getKotlinOpts()));
        stringArray = new String[]{"build.gradle.kts"};
        FileUtils.INSTANCE.createFile(basePath.resolve(stringArray), GradleTemplates.INSTANCE.createGradlePackageScript(script, jarArtifact));
        this.executor.createPackage(basePath);
        OsPathExtKt.toNativeFile((OsPath)packageFile).setExecutable(true);
        return packageFile;
    }
}

