/*
 * Decompiled with CFR 0.152.
 */
package io.github.kscripting.kscript.resolver;

import io.github.kscripting.kscript.model.Code;
import io.github.kscripting.kscript.model.CompilerOpt;
import io.github.kscripting.kscript.model.Content;
import io.github.kscripting.kscript.model.Dependency;
import io.github.kscripting.kscript.model.DeprecatedItem;
import io.github.kscripting.kscript.model.Entry;
import io.github.kscripting.kscript.model.ImportName;
import io.github.kscripting.kscript.model.Include;
import io.github.kscripting.kscript.model.KotlinOpt;
import io.github.kscripting.kscript.model.PackageName;
import io.github.kscripting.kscript.model.Repository;
import io.github.kscripting.kscript.model.ScriptAnnotation;
import io.github.kscripting.kscript.model.ScriptNode;
import io.github.kscripting.kscript.model.ScriptingConfig;
import io.github.kscripting.kscript.model.Section;
import io.github.kscripting.kscript.model.SheBang;
import io.github.kscripting.kscript.parser.Parser;
import io.github.kscripting.kscript.resolver.InputOutputResolver;
import io.github.kscripting.kscript.resolver.ResolutionContext;
import io.github.kscripting.kscript.util.UriUtils;
import io.github.kscripting.shell.model.ScriptLocation;
import io.github.kscripting.shell.model.ScriptSource;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ4\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J>\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00170\n2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00132\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lio/github/kscripting/kscript/resolver/SectionResolver;", "", "inputOutputResolver", "Lio/github/kscripting/kscript/resolver/InputOutputResolver;", "parser", "Lio/github/kscripting/kscript/parser/Parser;", "scriptingConfig", "Lio/github/kscripting/kscript/model/ScriptingConfig;", "(Lio/github/kscripting/kscript/resolver/InputOutputResolver;Lio/github/kscripting/kscript/parser/Parser;Lio/github/kscripting/kscript/model/ScriptingConfig;)V", "resolve", "", "Lio/github/kscripting/kscript/model/Section;", "scriptLocation", "Lio/github/kscripting/shell/model/ScriptLocation;", "scriptText", "", "allowLocalReferences", "", "maxResolutionLevel", "", "resolutionContext", "Lio/github/kscripting/kscript/resolver/ResolutionContext;", "resolveAnnotation", "Lio/github/kscripting/kscript/model/ScriptAnnotation;", "scriptAnnotation", "includeContext", "Ljava/net/URI;", "currentLevel", "resolveIncludeUri", "include", "kscript"})
public final class SectionResolver {
    @NotNull
    private final InputOutputResolver inputOutputResolver;
    @NotNull
    private final Parser parser;
    @NotNull
    private final ScriptingConfig scriptingConfig;

    public SectionResolver(@NotNull InputOutputResolver inputOutputResolver, @NotNull Parser parser, @NotNull ScriptingConfig scriptingConfig) {
        Intrinsics.checkNotNullParameter((Object)inputOutputResolver, (String)"inputOutputResolver");
        Intrinsics.checkNotNullParameter((Object)parser, (String)"parser");
        Intrinsics.checkNotNullParameter((Object)scriptingConfig, (String)"scriptingConfig");
        this.inputOutputResolver = inputOutputResolver;
        this.parser = parser;
        this.scriptingConfig = scriptingConfig;
    }

    @NotNull
    public final List<Section> resolve(@NotNull ScriptLocation scriptLocation, @NotNull String scriptText2, boolean allowLocalReferences, int maxResolutionLevel, @NotNull ResolutionContext resolutionContext) {
        Intrinsics.checkNotNullParameter((Object)scriptLocation, (String)"scriptLocation");
        Intrinsics.checkNotNullParameter((Object)scriptText2, (String)"scriptText");
        Intrinsics.checkNotNullParameter((Object)resolutionContext, (String)"resolutionContext");
        List<Section> sections = this.parser.parse(scriptLocation, scriptText2);
        List resultingSections = new ArrayList();
        for (Section section : sections) {
            List resultingScriptAnnotations = new ArrayList();
            for (ScriptAnnotation annotation : section.getScriptAnnotations()) {
                CollectionsKt.addAll((Collection)resultingScriptAnnotations, (Iterable)this.resolveAnnotation(annotation, scriptLocation.getSourceContextUri(), allowLocalReferences, scriptLocation.getLevel(), maxResolutionLevel, resolutionContext));
            }
            ((Collection)resultingSections).add(new Section(section.getCode(), resultingScriptAnnotations));
        }
        return resultingSections;
    }

    private final List<ScriptAnnotation> resolveAnnotation(ScriptAnnotation scriptAnnotation, URI includeContext, boolean allowLocalReferences, int currentLevel, int maxResolutionLevel, ResolutionContext resolutionContext) {
        List resolvedScriptAnnotations = new ArrayList();
        ScriptAnnotation scriptAnnotation2 = scriptAnnotation;
        if (scriptAnnotation2 instanceof SheBang) {
            ((Collection)resolvedScriptAnnotations).add(scriptAnnotation);
        } else if (scriptAnnotation2 instanceof Code) {
            ((Collection)resolvedScriptAnnotations).add(scriptAnnotation);
        } else if (scriptAnnotation2 instanceof ScriptNode) {
            ((Collection)resolvedScriptAnnotations).add(scriptAnnotation);
        } else if (scriptAnnotation2 instanceof Include) {
            URI uri = this.resolveIncludeUri(includeContext, ((Include)scriptAnnotation).unbox-impl());
            if (currentLevel < maxResolutionLevel && !resolutionContext.getUriRegistry().contains(uri)) {
                ScriptSource scriptSource;
                resolutionContext.getUriRegistry().add(uri);
                ScriptSource scriptSource2 = scriptSource = UriUtils.INSTANCE.isRegularFile(uri) ? ScriptSource.FILE : ScriptSource.HTTP;
                if (scriptSource == ScriptSource.FILE && !allowLocalReferences) {
                    throw new IllegalStateException("References to local files from remote scripts are disallowed.");
                }
                Content content = this.inputOutputResolver.resolveContent(uri);
                ScriptLocation scriptLocation = new ScriptLocation(currentLevel + 1, scriptSource, content.getScriptType(), uri, content.getContextUri(), content.getFileName());
                List<Section> newSections = this.resolve(scriptLocation, content.getText(), allowLocalReferences && scriptSource == ScriptSource.FILE, maxResolutionLevel, resolutionContext);
                ScriptNode scriptNode = new ScriptNode(scriptLocation, newSections);
                resolutionContext.getScriptNodes().add(scriptNode);
                ((Collection)resolvedScriptAnnotations).add(scriptNode);
            }
            resolutionContext.getIncludes().add((Include)scriptAnnotation);
            ((Collection)resolvedScriptAnnotations).add(scriptAnnotation);
        } else if (scriptAnnotation2 instanceof PackageName) {
            if (resolutionContext.getPackageName-tccyTyo() == null || resolutionContext.getPackageLevel() > currentLevel) {
                PackageName packageName = (PackageName)scriptAnnotation;
                resolutionContext.setPackageName-EkfO8Pc(packageName != null ? packageName.unbox-impl() : null);
                resolutionContext.setPackageLevel(currentLevel);
            }
            ((Collection)resolvedScriptAnnotations).add(scriptAnnotation);
        } else if (scriptAnnotation2 instanceof Entry) {
            if (resolutionContext.getEntryPoint-_L1MFNs() == null || resolutionContext.getEntryLevel() > currentLevel) {
                Entry entry = (Entry)scriptAnnotation;
                resolutionContext.setEntryPoint-7bAg8EQ(entry != null ? entry.unbox-impl() : null);
                resolutionContext.setEntryLevel(currentLevel);
            }
            ((Collection)resolvedScriptAnnotations).add(scriptAnnotation);
        } else if (scriptAnnotation2 instanceof ImportName) {
            resolutionContext.getImportNames().add((ImportName)scriptAnnotation);
            ((Collection)resolvedScriptAnnotations).add(scriptAnnotation);
        } else if (scriptAnnotation2 instanceof Dependency) {
            resolutionContext.getDependencies().add((Dependency)scriptAnnotation);
            ((Collection)resolvedScriptAnnotations).add(scriptAnnotation);
        } else if (scriptAnnotation2 instanceof KotlinOpt) {
            resolutionContext.getKotlinOpts().add((KotlinOpt)scriptAnnotation);
            ((Collection)resolvedScriptAnnotations).add(scriptAnnotation);
        } else if (scriptAnnotation2 instanceof CompilerOpt) {
            resolutionContext.getCompilerOpts().add((CompilerOpt)scriptAnnotation);
            ((Collection)resolvedScriptAnnotations).add(scriptAnnotation);
        } else if (scriptAnnotation2 instanceof Repository) {
            Repository repository = new Repository(((Repository)scriptAnnotation).getId(), StringsKt.replace$default((String)((Repository)scriptAnnotation).getUrl(), (String)"{{KSCRIPT_REPOSITORY_URL}}", (String)this.scriptingConfig.getProvidedRepositoryUrl(), (boolean)false, (int)4, null), StringsKt.replace$default((String)((Repository)scriptAnnotation).getUser(), (String)"{{KSCRIPT_REPOSITORY_USER}}", (String)this.scriptingConfig.getProvidedRepositoryUser(), (boolean)false, (int)4, null), StringsKt.replace$default((String)((Repository)scriptAnnotation).getPassword(), (String)"{{KSCRIPT_REPOSITORY_PASSWORD}}", (String)this.scriptingConfig.getProvidedRepositoryPassword(), (boolean)false, (int)4, null));
            resolutionContext.getRepositories().add(repository);
            ((Collection)resolvedScriptAnnotations).add(repository);
        } else if (scriptAnnotation2 instanceof DeprecatedItem) {
            resolutionContext.getDeprecatedItems().add((DeprecatedItem)scriptAnnotation);
        }
        return resolvedScriptAnnotations;
    }

    private final URI resolveIncludeUri(URI includeContext, String include) {
        URI uRI;
        if (StringsKt.startsWith$default((String)include, (String)"/", (boolean)false, (int)2, null)) {
            String string = include.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            uRI = this.inputOutputResolver.resolveUriRelativeToRoot(string);
        } else if (StringsKt.startsWith$default((String)include, (String)"~/", (boolean)false, (int)2, null)) {
            String string = include.substring(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            uRI = this.inputOutputResolver.resolveUriRelativeToHomeDir(string);
        } else {
            uRI = includeContext.resolve(new URI(StringsKt.removePrefix((String)include, (CharSequence)"./")));
        }
        URI result = uRI;
        URI uRI2 = result.normalize();
        Intrinsics.checkNotNullExpressionValue((Object)uRI2, (String)"result.normalize()");
        return uRI2;
    }
}

