/*
 * Decompiled with CFR 0.152.
 */
package me.leavestyle.handler;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCacheHandler<K, V, R> {
    private static final Logger log = LoggerFactory.getLogger(AbstractCacheHandler.class);
    @NonNull
    private Boolean cacheOn;

    protected abstract Map<K, V> fetchFromCache(List<K> var1);

    protected abstract Map<K, V> fetchFromDb(List<K> var1);

    protected abstract void writeToCache(List<K> var1, Map<K, V> var2);

    protected abstract List<R> mergeData(List<K> var1, Map<K, V> var2, Map<K, V> var3);

    public List<R> handle(List<K> keys) {
        List filterKeys = keys.stream().filter(Objects::nonNull).collect(Collectors.toList());
        if (!this.cacheOn.booleanValue()) {
            log.debug("cacheOn is false, query DB");
            return this.mergeData(filterKeys, new HashMap(), this.fetchFromCache(filterKeys));
        }
        Map cachedData = this.fetchFromCache(filterKeys);
        List unCachedKeys = this.toUncachedKeys(filterKeys, cachedData);
        Map dbData = this.fetchFromDb(unCachedKeys);
        this.writeToCache(unCachedKeys, dbData);
        return this.mergeData(filterKeys, cachedData, dbData);
    }

    private List<K> toUncachedKeys(List<K> keys, Map<K, V> cacheMap) {
        return keys.stream().filter(key -> !cacheMap.containsKey(key)).distinct().collect(Collectors.toList());
    }

    private static <K, V, R> Boolean $default$cacheOn() {
        return Boolean.TRUE;
    }

    protected AbstractCacheHandler(AbstractCacheHandlerBuilder<K, V, R, ?, ?> b) {
        this.cacheOn = ((AbstractCacheHandlerBuilder)b).cacheOn$set ? ((AbstractCacheHandlerBuilder)b).cacheOn$value : AbstractCacheHandler.$default$cacheOn();
        if (this.cacheOn == null) {
            throw new NullPointerException("cacheOn is marked non-null but is null");
        }
    }

    public static abstract class AbstractCacheHandlerBuilder<K, V, R, C extends AbstractCacheHandler<K, V, R>, B extends AbstractCacheHandlerBuilder<K, V, R, C, B>> {
        private boolean cacheOn$set;
        private Boolean cacheOn$value;

        protected B $fillValuesFrom(C instance) {
            AbstractCacheHandlerBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return this.self();
        }

        private static <K, V, R> void $fillValuesFromInstanceIntoBuilder(AbstractCacheHandler<K, V, R> instance, AbstractCacheHandlerBuilder<K, V, R, ?, ?> b) {
            b.cacheOn(((AbstractCacheHandler)instance).cacheOn);
        }

        protected abstract B self();

        public abstract C build();

        public B cacheOn(@NonNull Boolean cacheOn) {
            if (cacheOn == null) {
                throw new NullPointerException("cacheOn is marked non-null but is null");
            }
            this.cacheOn$value = cacheOn;
            this.cacheOn$set = true;
            return this.self();
        }

        public String toString() {
            return "AbstractCacheHandler.AbstractCacheHandlerBuilder(cacheOn$value=" + this.cacheOn$value + ")";
        }
    }
}

