package com.liecoder.framework.banner.drawer

import com.liecoder.framework.banner.mode.IndicatorStyle
import com.liecoder.framework.banner.options.IndicatorOptions

/**
 * Indicator Drawer Factory.
 */
internal object DrawerFactory {
    fun createDrawer(indicatorOptions: IndicatorOptions): IDrawer {
        return when (indicatorOptions.indicatorStyle) {
            IndicatorStyle.DASH       -> DashDrawer(indicatorOptions)
            IndicatorStyle.ROUND_RECT -> RoundRectDrawer(indicatorOptions)
            else                      -> CircleDrawer(indicatorOptions)
        }
    }
}
