package com.liecoder.framework.base

import android.content.Context
import android.graphics.drawable.Drawable
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.FragmentActivity
import androidx.lifecycle.Lifecycle
import androidx.lifecycle.LifecycleEventObserver
import androidx.lifecycle.LifecycleOwner
import androidx.viewbinding.ViewBinding
import com.liecoder.framework.dialog.BaseDialogFragment
import com.liecoder.framework.dialog.LoadingView
import com.liecoder.framework.ktx.i
import com.liecoder.framework.toast.TipsToast
import com.liecoder.framework.toast.TipsToast.Errors
import com.liecoder.framework.toast.TipsToast.Infos
import com.liecoder.framework.toast.TipsToast.Success
import com.liecoder.framework.toast.TipsToast.Warnings
import com.liecoder.framework.toast.ToastStyle
import java.lang.reflect.ParameterizedType
import java.lang.reflect.Type


@Suppress("UNCHECKED_CAST")
class BaseFragment<VB : ViewBinding> : BaseDialogFragment(), IBaseService, IViewBindingService,
                                       LifecycleEventObserver {

    private val mActivity: FragmentActivity by lazy { requireActivity() }

    private val mLoadingView: LoadingView by lazy { LoadingView(mContext = mActivity) }

    override lateinit var mBinding: VB
    protected val TAG = this::class.java.simpleName


    override fun onAttach(context: Context) {
        super.onAttach(context)
        lifecycle.addObserver(this)
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View {
        mBinding = viewBinding()
        init()
        setupViews()
        return mBinding.root
    }

    override fun onViewCreated(
        view: View,
        savedInstanceState: Bundle?
    ) {
        super.onViewCreated(
            view,
            savedInstanceState
        )
        loadData()
    }

    override fun viewBinding(): VB {
        val binding: VB
        val type: Type = javaClass.genericSuperclass!!
        val clazz: Class<VB> = ((type as ParameterizedType).actualTypeArguments[0] as Class<VB>)
        val inflateMethod = clazz.getDeclaredMethod(
            "inflate",
            LayoutInflater::class.java
        )
        binding = inflateMethod.invoke(
            this,
            layoutInflater
        ) as VB
        return binding
    }

    override fun setContentView() {
    }

    override fun init() {
    }

    override fun setupViews() {
    }

    override fun loadData() {
    }

    override fun setupStatusBar() {
    }

    override fun statusBarDarkContent(): Boolean = false

    override fun statusBarColor(): Int = 0

    override fun statusBarTranslucent(): Boolean = false

    override fun onStateChanged(
        source: LifecycleOwner,
        event: Lifecycle.Event
    ) {
        i("FragmentStateChanged: $event")
    }

    override fun showLoading(
        show: Boolean,
        message: String?
    ) {
        if (!show) return hideLoading()
        mLoadingView.show(message = message)
    }

    override fun hideLoading() = mLoadingView.dismiss()


    override fun success(message: CharSequence?) = Success.show(message)

    override fun errors(message: CharSequence?) = Errors.show(message)

    override fun warnings(message: CharSequence?) = Warnings.show(message)

    override fun info(message: CharSequence?) = Infos.show(message)

    override fun custom(
        message: CharSequence?,
        successIcon: Drawable?,
        errorIcon: Drawable?,
        warningIcon: Drawable?,
        gravity: Int,
        xOffset: Int,
        yOffset: Int,
        duration: Int,
        style: ToastStyle?
    ) = TipsToast.custom(
        message = message,
        successIcon = successIcon,
        errorIcon = errorIcon,
        warningIcon = warningIcon,
        gravity = gravity,
        xOffset = xOffset,
        yOffset = yOffset,
        duration = duration,
        style = style
    )
}