package com.liecoder.framework.crop

/**
 * 枚举类，表示不同的锚点方向。
 */
enum class Anchor(val position: Int) {
    /**
     * 左上角。
     */
    LT(0),

    /**
     * 右上角。
     */
    RT(1),

    /**
     * 右下角。
     */
    RB(2),

    /**
     * 左下角。
     */
    LB(3),

    /**
     * 顶部中点。
     */
    T(4),

    /**
     * 右侧中点。
     */
    R(5),

    /**
     * 底部中点。
     */
    B(6),

    /**
     * 左侧中点。
     */
    L(7);
}
