package com.liecoder.framework.toast

import android.content.Context
import androidx.core.content.res.ResourcesCompat
import com.liecoder.framework.R


/**
 * Author: lieco(liecoder@163.com)
 * Date: 2024/8/19
 * Version: 1.0
 */
class ErrorImpl(context: Context) : TipsToastImpl(
    context = context,
    mErrorIcon = ResourcesCompat.getDrawable(
        context.resources,
        R.drawable.ic_error_toast,
        context.theme
    )
) {

    fun show(message: CharSequence?) = super.show(message, ToastStyle.ERROR)
}