/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor;

import com.squareup.javapoet.ClassName;
import io.github.linpeilie.annotations.AutoMapper;
import io.github.linpeilie.annotations.AutoMapping;
import io.github.linpeilie.annotations.ComponentModelConfig;
import io.github.linpeilie.annotations.MapperConfig;
import io.github.linpeilie.processor.AbstractAdapterMapperGenerator;
import io.github.linpeilie.processor.AdapterMethodMetadata;
import io.github.linpeilie.processor.AutoMapperGenerator;
import io.github.linpeilie.processor.AutoMapperMetadata;
import io.github.linpeilie.processor.AutoMapperProperties;
import io.github.linpeilie.processor.AutoMappingMetadata;
import io.github.linpeilie.processor.DefaultAdapterMapperGenerator;
import io.github.linpeilie.processor.MapperConfigGenerator;
import io.github.linpeilie.processor.SpringAdapterMapperGenerator;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;

@SupportedAnnotationTypes(value={"io.github.linpeilie.annotations.AutoMapper", "io.github.linpeilie.annotations.MapperConfig", "io.github.linpeilie.annotations.ComponentModelConfig"})
public class AutoMapperProcessor
extends AbstractProcessor {
    private final AutoMapperGenerator mapperGenerator;
    private AbstractAdapterMapperGenerator adapterMapperGenerator;
    private final MapperConfigGenerator mapperConfigGenerator;
    private final Map<String, AdapterMethodMetadata> methodMap = new HashMap<String, AdapterMethodMetadata>();
    private final Set<String> mapperSet = new HashSet<String>();

    public AutoMapperProcessor() {
        this.mapperGenerator = new AutoMapperGenerator();
        this.mapperConfigGenerator = new MapperConfigGenerator();
    }

    private boolean isAutoMapperAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.AutoMapper".contentEquals(annotation.getQualifiedName());
    }

    private boolean isMapperConfigAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.MapperConfig".contentEquals(annotation.getQualifiedName());
    }

    private boolean isComponentModelConfigAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.ComponentModelConfig".contentEquals(annotation.getQualifiedName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean hasAutoMapper = annotations.stream().anyMatch(this::isAutoMapperAnnotation);
        if (!hasAutoMapper) {
            return false;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "start refresh properties");
        this.refreshProperties(annotations, roundEnv);
        this.adapterMapperGenerator = AutoMapperProperties.getComponentModel().contentEquals("spring") ? new SpringAdapterMapperGenerator() : new DefaultAdapterMapperGenerator();
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "start write config class");
        this.writeConfigClass();
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "start generate mapper class");
        annotations.stream().filter(this::isAutoMapperAnnotation).forEach(annotation -> this.processAutoMapperAnnotation(roundEnv, (TypeElement)annotation));
        return false;
    }

    private void refreshProperties(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        annotations.stream().filter(this::isMapperConfigAnnotation).findFirst().flatMap(annotation -> roundEnv.getElementsAnnotatedWith((TypeElement)annotation).stream().findFirst()).ifPresent(element -> {
            MapperConfig mapperConfig = element.getAnnotation(MapperConfig.class);
            String mapperPackage = StringUtils.isEmpty((CharSequence)mapperConfig.mapperPackage()) ? this.getPackageName((Element)element) : mapperConfig.mapperPackage();
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "mapper package " + mapperPackage);
            AutoMapperProperties.setMapperPackage(mapperPackage);
        });
        annotations.stream().filter(this::isComponentModelConfigAnnotation).findFirst().flatMap(annotation -> roundEnv.getElementsAnnotatedWith((TypeElement)annotation).stream().findFirst()).ifPresent(element -> {
            ComponentModelConfig componentModelConfig = element.getAnnotation(ComponentModelConfig.class);
            String componentModel = StringUtils.isEmpty((CharSequence)componentModelConfig.componentModel()) ? "default" : componentModelConfig.componentModel();
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "component model " + componentModel);
            AutoMapperProperties.setComponentModel(componentModel);
        });
    }

    private String getPackageName(Element element) {
        return String.valueOf(this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName());
    }

    private void writeConfigClass() {
        this.mapperConfigGenerator.write(this.processingEnv);
    }

    private void processAutoMapperAnnotation(RoundEnvironment roundEnv, TypeElement annotation) {
        List<AutoMapperMetadata> autoMapperMetadataList = roundEnv.getElementsAnnotatedWith(annotation).stream().map(this::buildAutoMapperMetadata).filter(Objects::nonNull).collect(Collectors.toList());
        autoMapperMetadataList.forEach(autoMapperMetadata -> this.mapperSet.add(autoMapperMetadata.mapperName()));
        ArrayList reverseMapperMetadataList = new ArrayList();
        autoMapperMetadataList.forEach(autoMapperMetadata -> {
            AutoMapperMetadata reverseMapperMetadata = this.reverseMapper((AutoMapperMetadata)autoMapperMetadata);
            if (!this.mapperSet.add(reverseMapperMetadata.mapperName())) {
                return;
            }
            reverseMapperMetadataList.add(reverseMapperMetadata);
        });
        autoMapperMetadataList.addAll(reverseMapperMetadataList);
        autoMapperMetadataList.forEach(this::writeAutoMapperClassFile);
        this.adapterMapperGenerator.write(this.processingEnv, this.methodMap.values());
    }

    private AutoMapperMetadata reverseMapper(AutoMapperMetadata autoMapperMetadata) {
        AutoMapperMetadata reverseMapperMetadata = new AutoMapperMetadata();
        reverseMapperMetadata.setSourceClassName(autoMapperMetadata.getTargetClassName());
        reverseMapperMetadata.setTargetClassName(autoMapperMetadata.getSourceClassName());
        List<AutoMappingMetadata> fieldMetadataList = autoMapperMetadata.getFieldMappingList().stream().map(fieldMapping -> {
            AutoMappingMetadata autoMappingMetadata = new AutoMappingMetadata();
            autoMappingMetadata.setSource(fieldMapping.getTarget());
            autoMappingMetadata.setTarget(fieldMapping.getSource());
            return autoMappingMetadata;
        }).collect(Collectors.toList());
        reverseMapperMetadata.setFieldMappingList(fieldMetadataList);
        return reverseMapperMetadata;
    }

    private void writeAutoMapperClassFile(AutoMapperMetadata metadata) {
        String mapperPackage = metadata.mapperPackage();
        String mapperClassName = metadata.mapperName();
        try (Writer writer = this.processingEnv.getFiler().createSourceFile(mapperPackage + "." + mapperClassName, new Element[0]).openWriter();){
            this.mapperGenerator.write(metadata, writer);
            this.addAdapterMethod(metadata.getSourceClassName(), metadata.getTargetClassName(), ClassName.get((String)mapperPackage, (String)mapperClassName, (String[])new String[0]));
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error while opening " + metadata.mapperName() + " output file: " + e.getMessage());
        }
    }

    private void addAdapterMethod(ClassName source, ClassName target, ClassName mapper) {
        AdapterMethodMetadata adapterMethodMetadata = AdapterMethodMetadata.newInstance(source, target, mapper);
        this.methodMap.put(adapterMethodMetadata.getMethodName(), adapterMethodMetadata);
    }

    private AutoMapperMetadata buildAutoMapperMetadata(Element ele) {
        AutoMapper autoMapperAnnotation = ele.getAnnotation(AutoMapper.class);
        if (autoMapperAnnotation == null) {
            return null;
        }
        ClassName source = ClassName.get((TypeElement)((TypeElement)ele));
        ClassName target = this.transToClassName(() -> ((AutoMapper)autoMapperAnnotation).target());
        if (target == null) {
            return null;
        }
        List<ClassName> uses = this.transToClassNameList(() -> ((AutoMapper)autoMapperAnnotation).uses());
        List<AutoMappingMetadata> autoMappingMetadataList = this.buildFieldMappingMetadata((TypeElement)ele);
        AutoMapperMetadata metadata = new AutoMapperMetadata();
        metadata.setSourceClassName(source);
        metadata.setTargetClassName(target);
        metadata.setUsesClassNameList(uses);
        metadata.setFieldMappingList(autoMappingMetadataList);
        return metadata;
    }

    private List<AutoMappingMetadata> buildFieldMappingMetadata(TypeElement autoMapperEle) {
        ArrayList<AutoMappingMetadata> list = new ArrayList<AutoMappingMetadata>();
        if (!autoMapperEle.getKind().isClass()) {
            return list;
        }
        for (Element element : autoMapperEle.getEnclosedElements()) {
            AutoMapping autoMapping;
            if (element.getKind() != ElementKind.FIELD || (autoMapping = element.getAnnotation(AutoMapping.class)) == null) continue;
            AutoMappingMetadata metadata = new AutoMappingMetadata();
            metadata.setTarget(autoMapping.target());
            metadata.setSource(element.getSimpleName().toString());
            metadata.setIgnore(autoMapping.ignore());
            metadata.setExpression(autoMapping.expression());
            metadata.setDateFormat(autoMapping.dateFormat());
            metadata.setNumberFormat(autoMapping.numberFormat());
            list.add(metadata);
        }
        return list;
    }

    private ClassName transToClassName(Supplier<Class<?>> classSupplier) {
        TypeMirror typeMirror = null;
        try {
            Class<?> clazz = classSupplier.get();
        }
        catch (MirroredTypeException e) {
            typeMirror = e.getTypeMirror();
        }
        if (typeMirror == null) {
            return null;
        }
        return (ClassName)ClassName.get((TypeMirror)typeMirror);
    }

    private List<ClassName> transToClassNameList(Supplier<Class<?>[]> classSuppler) {
        List<? extends TypeMirror> typeMirrors = null;
        try {
            Class<?>[] classArray = classSuppler.get();
        }
        catch (MirroredTypesException e) {
            typeMirrors = e.getTypeMirrors();
        }
        return typeMirrors.stream().map(typeMirror -> (ClassName)ClassName.get((TypeMirror)typeMirror)).collect(Collectors.toList());
    }
}

