/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import io.github.linpeilie.processor.AutoMapperProperties;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.tools.Diagnostic;

public class MapperConfigGenerator {
    public void write(ProcessingEnvironment processingEnv) {
        try (Writer writer = processingEnv.getFiler().createSourceFile(AutoMapperProperties.getConfigPackage() + "." + AutoMapperProperties.getConfigClassName(), new Element[0]).openWriter();){
            JavaFile.builder((String)AutoMapperProperties.getConfigPackage(), (TypeSpec)this.createConfigTypeSpec()).build().writeTo((Appendable)writer);
        }
        catch (IOException e) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error while opening " + AutoMapperProperties.getConfigClassName() + " output file: " + e.getMessage());
        }
    }

    private TypeSpec createConfigTypeSpec() {
        return TypeSpec.interfaceBuilder((String)AutoMapperProperties.getConfigClassName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(this.buildMapperConfigAnnotationSpec()).build();
    }

    private AnnotationSpec buildMapperConfigAnnotationSpec() {
        CodeBlock.Builder usesCodeBuilder = CodeBlock.builder().add("{", new Object[0]);
        usesCodeBuilder.add("$T.class", new Object[]{ClassName.get((String)AutoMapperProperties.getAdapterPackage(), (String)AutoMapperProperties.getAdapterClassName(), (String[])new String[0])});
        CodeBlock usesCodeBlock = usesCodeBuilder.add("}", new Object[0]).build();
        return AnnotationSpec.builder((ClassName)ClassName.get((String)"org.mapstruct", (String)"MapperConfig", (String[])new String[0])).addMember("componentModel", CodeBlock.builder().add("$S", new Object[]{AutoMapperProperties.getComponentModel()}).build()).addMember("uses", usesCodeBlock).build();
    }
}

