/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import io.github.linpeilie.processor.AbstractAdapterMapperGenerator;
import io.github.linpeilie.processor.AdapterMethodMetadata;
import io.github.linpeilie.processor.AutoMapperProperties;
import java.util.Collection;
import javax.lang.model.element.Modifier;

public class SpringAdapterMapperGenerator
extends AbstractAdapterMapperGenerator {
    @Override
    protected TypeSpec createTypeSpec(Collection<AdapterMethodMetadata> adapterMethods) {
        TypeSpec.Builder adapterBuilder = TypeSpec.classBuilder((ClassName)ClassName.get((String)AutoMapperProperties.getAdapterPackage(), (String)AutoMapperProperties.getAdapterClassName(), (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(ClassName.get((String)"org.springframework.stereotype", (String)"Component", (String[])new String[0]));
        adapterMethods.forEach(adapterMethod -> adapterBuilder.addField(this.buildMapperField(adapterMethod.getMapper())).addMethod(this.buildMapperSetterMethod(adapterMethod.getMapper())).addMethod(this.buildProxyMethod((AdapterMethodMetadata)adapterMethod)));
        return adapterBuilder.build();
    }

    private FieldSpec buildMapperField(ClassName mapper) {
        return FieldSpec.builder((TypeName)mapper, (String)this.firstWordToLower(mapper.simpleName()), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build();
    }

    private String firstWordToLower(String str) {
        return str.substring(0, 1).toLowerCase() + str.substring(1);
    }

    private MethodSpec buildProxyMethod(AdapterMethodMetadata adapterMethodMetadata) {
        ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)adapterMethodMetadata.getSource(), (String)this.firstWordToLower(adapterMethodMetadata.getSource().simpleName()), (Modifier[])new Modifier[0]).build();
        return MethodSpec.methodBuilder((String)(this.firstWordToLower(adapterMethodMetadata.getSource().simpleName()) + "To" + adapterMethodMetadata.getTarget().simpleName())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameterSpec).returns((TypeName)adapterMethodMetadata.getTarget()).addStatement("return $N.convert($N)", new Object[]{this.firstWordToLower(adapterMethodMetadata.getMapper().simpleName()), this.firstWordToLower(adapterMethodMetadata.getSource().simpleName())}).build();
    }

    private MethodSpec buildMapperSetterMethod(ClassName mapper) {
        ParameterSpec parameterSpec = this.buildMapperSetterParameter(mapper);
        return MethodSpec.methodBuilder((String)("set" + mapper.simpleName())).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(parameterSpec).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"org.springframework.beans.factory.annotation", (String)"Autowired", (String[])new String[0])).build()).addStatement("this.$N = $N", new Object[]{this.buildMapperField(mapper), parameterSpec}).build();
    }

    private ParameterSpec buildMapperSetterParameter(ClassName mapper) {
        return ParameterSpec.builder((TypeName)mapper, (String)this.firstWordToLower(mapper.simpleName()), (Modifier[])new Modifier[0]).addAnnotation(AnnotationSpec.builder((ClassName)ClassName.get((String)"org.springframework.context.annotation", (String)"Lazy", (String[])new String[0])).build()).build();
    }
}

