/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import io.github.linpeilie.processor.AutoMapperProperties;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.tools.Diagnostic;

public class MapperConfigGenerator {
    public void write(ProcessingEnvironment processingEnv, String mapstructConfigName, String adapterClassName) {
        try (Writer writer = processingEnv.getFiler().createSourceFile(AutoMapperProperties.getConfigPackage() + "." + mapstructConfigName, new Element[0]).openWriter();){
            JavaFile.builder((String)AutoMapperProperties.getConfigPackage(), (TypeSpec)this.createConfigTypeSpec(mapstructConfigName, adapterClassName)).build().writeTo((Appendable)writer);
        }
        catch (IOException e) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error while opening " + AutoMapperProperties.getConfigClassName() + " output file: " + e.getMessage());
        }
    }

    private TypeSpec createConfigTypeSpec(String mapstructConfigName, String adapterClassName) {
        return TypeSpec.interfaceBuilder((String)mapstructConfigName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(this.buildMapperConfigAnnotationSpec(adapterClassName)).build();
    }

    private AnnotationSpec buildMapperConfigAnnotationSpec(String adapterClassName) {
        CodeBlock.Builder usesCodeBuilder = CodeBlock.builder().add("{", new Object[0]);
        usesCodeBuilder.add("$T.class", new Object[]{ClassName.get((String)AutoMapperProperties.getAdapterPackage(), (String)adapterClassName, (String[])new String[0])});
        CodeBlock usesCodeBlock = usesCodeBuilder.add("}", new Object[0]).build();
        return AnnotationSpec.builder((ClassName)ClassName.get((String)"org.mapstruct", (String)"MapperConfig", (String[])new String[0])).addMember("componentModel", CodeBlock.builder().add("$S", new Object[]{AutoMapperProperties.getComponentModel()}).build()).addMember("uses", usesCodeBlock).build();
    }
}

