/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor;

import com.squareup.javapoet.ClassName;
import io.github.linpeilie.annotations.AutoMapMapper;
import io.github.linpeilie.annotations.AutoMapper;
import io.github.linpeilie.annotations.AutoMappers;
import io.github.linpeilie.annotations.AutoMapping;
import io.github.linpeilie.annotations.AutoMappings;
import io.github.linpeilie.annotations.ComponentModelConfig;
import io.github.linpeilie.annotations.MapperConfig;
import io.github.linpeilie.processor.AbstractAdapterMapperGenerator;
import io.github.linpeilie.processor.AutoMapperProperties;
import io.github.linpeilie.processor.generator.AutoMapperGenerator;
import io.github.linpeilie.processor.generator.DefaultAdapterMapperGenerator;
import io.github.linpeilie.processor.generator.MapperConfigGenerator;
import io.github.linpeilie.processor.generator.SpringAdapterMapperGenerator;
import io.github.linpeilie.processor.metadata.AbstractAdapterMethodMetadata;
import io.github.linpeilie.processor.metadata.AdapterMapMethodMetadata;
import io.github.linpeilie.processor.metadata.AdapterMethodMetadata;
import io.github.linpeilie.processor.metadata.AutoMapMapperMetadata;
import io.github.linpeilie.processor.metadata.AutoMapperMetadata;
import io.github.linpeilie.processor.metadata.AutoMappingMetadata;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;

@SupportedAnnotationTypes(value={"io.github.linpeilie.annotations.AutoMapper", "io.github.linpeilie.annotations.AutoMappers", "io.github.linpeilie.annotations.AutoMapMapper", "io.github.linpeilie.annotations.MapperConfig", "io.github.linpeilie.annotations.ComponentModelConfig"})
public class AutoMapperProcessor
extends AbstractProcessor {
    private static final ClassName MAPPING_DEFAULT_TARGET = ClassName.get((String)"io.github.linpeilie", (String)"DefaultMapping", (String[])new String[0]);
    private final AutoMapperGenerator mapperGenerator;
    private AbstractAdapterMapperGenerator adapterMapperGenerator;
    private final MapperConfigGenerator mapperConfigGenerator;
    private final Map<String, AbstractAdapterMethodMetadata> methodMap = new HashMap<String, AbstractAdapterMethodMetadata>();
    private final Map<String, AbstractAdapterMethodMetadata> mapMethodMap = new HashMap<String, AbstractAdapterMethodMetadata>();
    private final List<AutoMapperMetadata> mapperList = new ArrayList<AutoMapperMetadata>();

    public AutoMapperProcessor() {
        this.mapperGenerator = new AutoMapperGenerator();
        this.mapperConfigGenerator = new MapperConfigGenerator();
    }

    private boolean isAutoMapperAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.AutoMapper".contentEquals(annotation.getQualifiedName());
    }

    private boolean isAutoMappersAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.AutoMappers".contentEquals(annotation.getQualifiedName());
    }

    private boolean isAutoMapMapperAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.AutoMapMapper".contentEquals(annotation.getQualifiedName());
    }

    private boolean isMapperConfigAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.MapperConfig".contentEquals(annotation.getQualifiedName());
    }

    private boolean isComponentModelConfigAnnotation(TypeElement annotation) {
        return "io.github.linpeilie.annotations.ComponentModelConfig".contentEquals(annotation.getQualifiedName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        boolean hasAutoMapper = annotations.stream().anyMatch(this::isAutoMapperAnnotation);
        if (!hasAutoMapper) {
            return false;
        }
        this.refreshProperties(annotations, roundEnv);
        this.adapterMapperGenerator = AutoMapperProperties.getComponentModel().contentEquals("spring") ? new SpringAdapterMapperGenerator() : new DefaultAdapterMapperGenerator();
        annotations.stream().filter(this::isAutoMapMapperAnnotation).findFirst().ifPresent(annotation -> this.processAutoMapMapperAnnotation(roundEnv, (TypeElement)annotation));
        annotations.stream().filter(this::isAutoMapperAnnotation).findFirst().ifPresent(annotation -> this.processAutoMapperAnnotation(roundEnv, (TypeElement)annotation));
        annotations.stream().filter(this::isAutoMappersAnnotation).findFirst().ifPresent(annotation -> this.processAutoMappersAnnotation(roundEnv, (TypeElement)annotation));
        this.generateMapper();
        return false;
    }

    private void processAutoMapMapperAnnotation(RoundEnvironment roundEnv, TypeElement annotation) {
        List<AutoMapperMetadata> autoMapMapperMetadataList = roundEnv.getElementsAnnotatedWith(annotation).stream().map(ele -> {
            if (ele.getAnnotation(AutoMapMapper.class) == null) {
                return null;
            }
            ClassName source = ClassName.get((String)"java.util", (String)"Map", (String[])new String[0]);
            ClassName target = ClassName.get((TypeElement)((TypeElement)ele));
            List<ClassName> uses = Arrays.asList(ClassName.get((String)"io.github.linpeilie.map", (String)"MapObjectConvert", (String[])new String[0]));
            AutoMapMapperMetadata autoMapperMetadata = new AutoMapMapperMetadata();
            autoMapperMetadata.setTargetClassName(target);
            autoMapperMetadata.setSourceClassName(source);
            autoMapperMetadata.setUsesClassNameList(uses);
            autoMapperMetadata.setSuperClass(ClassName.get((String)"io.github.linpeilie", (String)"BaseMapMapper", (String[])new String[0]));
            autoMapperMetadata.setSuperGenerics(new ClassName[]{target});
            autoMapperMetadata.setMapstructConfigClass(ClassName.get((String)AutoMapperProperties.getConfigPackage(), (String)AutoMapperProperties.getMapConfigClassName(), (String[])new String[0]));
            return autoMapperMetadata;
        }).filter(Objects::nonNull).collect(Collectors.toList());
        autoMapMapperMetadataList.forEach(metadata -> {
            this.writeAutoMapperClassFile((AutoMapperMetadata)metadata);
            this.addAdapterMapMethod(metadata.getSourceClassName(), metadata.getTargetClassName(), metadata.mapperClass(), false);
            this.addAdapterMapMethod(ClassName.get((String)"java.lang", (String)"Object", (String[])new String[0]), metadata.getTargetClassName(), metadata.mapperClass(), true);
        });
        this.adapterMapperGenerator.write(this.processingEnv, this.mapMethodMap.values(), AutoMapperProperties.getMapAdapterClassName());
        this.mapperConfigGenerator.write(this.processingEnv, AutoMapperProperties.getMapConfigClassName(), AutoMapperProperties.getMapAdapterClassName());
    }

    private void refreshProperties(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        annotations.stream().filter(this::isMapperConfigAnnotation).findFirst().flatMap(annotation -> roundEnv.getElementsAnnotatedWith((TypeElement)annotation).stream().findFirst()).ifPresent(element -> {
            MapperConfig mapperConfig = element.getAnnotation(MapperConfig.class);
            String mapperPackage = StringUtils.isEmpty((CharSequence)mapperConfig.mapperPackage()) ? this.getPackageName((Element)element) : mapperConfig.mapperPackage();
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "mapper package " + mapperPackage);
            AutoMapperProperties.setMapperPackage(mapperPackage);
        });
        annotations.stream().filter(this::isComponentModelConfigAnnotation).findFirst().flatMap(annotation -> roundEnv.getElementsAnnotatedWith((TypeElement)annotation).stream().findFirst()).ifPresent(element -> {
            ComponentModelConfig componentModelConfig = element.getAnnotation(ComponentModelConfig.class);
            String componentModel = StringUtils.isEmpty((CharSequence)componentModelConfig.componentModel()) ? "default" : componentModelConfig.componentModel();
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "component model " + componentModel);
            AutoMapperProperties.setComponentModel(componentModel);
        });
    }

    private String getPackageName(Element element) {
        return String.valueOf(this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName());
    }

    private void processAutoMapperAnnotation(RoundEnvironment roundEnv, TypeElement annotation) {
        List autoMapperMetadataList = roundEnv.getElementsAnnotatedWith(annotation).stream().map(this::buildAutoMapperMetadata).filter(Objects::nonNull).collect(Collectors.toList());
        this.mapperList.addAll(autoMapperMetadataList);
    }

    private void processAutoMappersAnnotation(RoundEnvironment roundEnv, TypeElement annotation) {
        List autoMapperMetadata = roundEnv.getElementsAnnotatedWith(annotation).stream().map(this::buildAutoMapperMetadataByAutoMappers).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        this.mapperList.addAll(autoMapperMetadata);
    }

    private void generateMapper() {
        HashSet mapperSet = new HashSet();
        this.mapperList.removeIf(mapper -> !mapperSet.add(mapper.mapperName()));
        ArrayList reverseMapperMetadataList = new ArrayList();
        this.mapperList.forEach(autoMapperMetadata -> {
            if (!autoMapperMetadata.isReverseConvertGenerate()) {
                return;
            }
            AutoMapperMetadata reverseMapperMetadata = this.reverseMapper((AutoMapperMetadata)autoMapperMetadata);
            if (!mapperSet.add(reverseMapperMetadata.mapperName())) {
                return;
            }
            reverseMapperMetadataList.add(reverseMapperMetadata);
        });
        this.mapperList.addAll(reverseMapperMetadataList);
        this.mapperList.forEach(metadata -> {
            this.writeAutoMapperClassFile((AutoMapperMetadata)metadata);
            this.addAdapterMethod(metadata.getSourceClassName(), metadata.getTargetClassName(), metadata.mapperClass());
        });
        this.adapterMapperGenerator.write(this.processingEnv, this.methodMap.values(), AutoMapperProperties.getAdapterClassName());
        this.mapperConfigGenerator.write(this.processingEnv, AutoMapperProperties.getConfigClassName(), AutoMapperProperties.getAdapterClassName());
    }

    private AutoMapperMetadata reverseMapper(AutoMapperMetadata autoMapperMetadata) {
        AutoMapperMetadata reverseMapperMetadata = new AutoMapperMetadata();
        reverseMapperMetadata.setSourceClassName(autoMapperMetadata.getTargetClassName());
        reverseMapperMetadata.setTargetClassName(autoMapperMetadata.getSourceClassName());
        reverseMapperMetadata.setSuperClass(autoMapperMetadata.getSuperClass());
        reverseMapperMetadata.setSuperGenerics(new ClassName[]{reverseMapperMetadata.getSourceClassName(), reverseMapperMetadata.getTargetClassName()});
        reverseMapperMetadata.setMapstructConfigClass(ClassName.get((String)AutoMapperProperties.getConfigPackage(), (String)AutoMapperProperties.getConfigClassName(), (String[])new String[0]));
        List<AutoMappingMetadata> fieldMetadataList = autoMapperMetadata.getFieldMappingList().stream().map(fieldMapping -> {
            AutoMappingMetadata autoMappingMetadata = new AutoMappingMetadata();
            autoMappingMetadata.setSource(fieldMapping.getTarget());
            autoMappingMetadata.setTarget(fieldMapping.getSource());
            return autoMappingMetadata;
        }).collect(Collectors.toList());
        reverseMapperMetadata.setFieldMappingList(fieldMetadataList);
        return reverseMapperMetadata;
    }

    private void writeAutoMapperClassFile(AutoMapperMetadata metadata) {
        String mapperPackage = metadata.mapperPackage();
        String mapperClassName = metadata.mapperName();
        try (Writer writer = this.processingEnv.getFiler().createSourceFile(mapperPackage + "." + mapperClassName, new Element[0]).openWriter();){
            this.mapperGenerator.write(metadata, writer);
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error while opening " + metadata.mapperName() + " output file: " + e.getMessage());
        }
    }

    private void addAdapterMethod(ClassName source, ClassName target, ClassName mapper) {
        AdapterMethodMetadata adapterMethodMetadata = AdapterMethodMetadata.newInstance(source, target, mapper);
        this.methodMap.put(adapterMethodMetadata.getMethodName(), adapterMethodMetadata);
    }

    private void addAdapterMapMethod(ClassName source, ClassName target, ClassName mapper, boolean objectConverter) {
        AdapterMapMethodMetadata adapterMapMethodMetadata = new AdapterMapMethodMetadata(source, target, mapper, objectConverter);
        this.mapMethodMap.put(adapterMapMethodMetadata.getMethodName(), adapterMapMethodMetadata);
    }

    private List<AutoMapperMetadata> buildAutoMapperMetadataByAutoMappers(Element ele) {
        AutoMappers autoMappers = ele.getAnnotation(AutoMappers.class);
        if (autoMappers == null) {
            return null;
        }
        return Arrays.stream(autoMappers.value()).map(autoMapper -> this.buildAutoMapperMetadata((AutoMapper)autoMapper, ele)).collect(Collectors.toList());
    }

    private AutoMapperMetadata buildAutoMapperMetadata(Element ele) {
        AutoMapper autoMapperAnnotation = ele.getAnnotation(AutoMapper.class);
        if (autoMapperAnnotation == null) {
            return null;
        }
        return this.buildAutoMapperMetadata(autoMapperAnnotation, ele);
    }

    private AutoMapperMetadata buildAutoMapperMetadata(AutoMapper autoMapper, Element ele) {
        ClassName source = ClassName.get((TypeElement)((TypeElement)ele));
        ClassName target = this.transToClassName(() -> ((AutoMapper)autoMapper).target());
        if (target == null) {
            return null;
        }
        List<ClassName> uses = this.transToClassNameList(() -> ((AutoMapper)autoMapper).uses());
        List<AutoMappingMetadata> autoMappingMetadataList = this.buildFieldMappingMetadata((TypeElement)ele);
        autoMappingMetadataList.removeIf(mappingMetadata -> {
            if (MAPPING_DEFAULT_TARGET.reflectionName().contentEquals(mappingMetadata.getTargetClass().reflectionName())) {
                return false;
            }
            return !target.reflectionName().contentEquals(mappingMetadata.getTargetClass().reflectionName());
        });
        AutoMapperMetadata metadata = new AutoMapperMetadata();
        metadata.setSourceClassName(source);
        metadata.setTargetClassName(target);
        metadata.setUsesClassNameList(uses);
        metadata.setFieldMappingList(autoMappingMetadataList);
        metadata.setSuperClass(ClassName.get((String)"io.github.linpeilie", (String)"BaseMapper", (String[])new String[0]));
        metadata.setSuperGenerics(new ClassName[]{source, target});
        metadata.setMapstructConfigClass(ClassName.get((String)AutoMapperProperties.getConfigPackage(), (String)AutoMapperProperties.getConfigClassName(), (String[])new String[0]));
        metadata.setReverseConvertGenerate(autoMapper.reverseConvertGenerate());
        return metadata;
    }

    private List<AutoMappingMetadata> buildFieldMappingMetadata(TypeElement autoMapperEle) {
        ArrayList<AutoMappingMetadata> list = new ArrayList<AutoMappingMetadata>();
        if (!autoMapperEle.getKind().isClass()) {
            return list;
        }
        for (Element element : autoMapperEle.getEnclosedElements()) {
            AutoMappings autoMappings;
            if (element.getKind() != ElementKind.FIELD) continue;
            AutoMapping autoMapping = element.getAnnotation(AutoMapping.class);
            if (autoMapping != null) {
                list.add(this.buildAutoMappingMetadata(autoMapping, element, autoMapperEle));
            }
            if ((autoMappings = element.getAnnotation(AutoMappings.class)) == null) continue;
            for (AutoMapping autoMappingEle : autoMappings.value()) {
                list.add(this.buildAutoMappingMetadata(autoMappingEle, element, autoMapperEle));
            }
        }
        list.removeIf(Objects::isNull);
        return list;
    }

    private AutoMappingMetadata buildAutoMappingMetadata(AutoMapping autoMapping, Element ele, TypeElement type) {
        ClassName targetClass = this.transToClassName(() -> ((AutoMapping)autoMapping).targetClass());
        if (targetClass == null) {
            return null;
        }
        AutoMappingMetadata metadata = new AutoMappingMetadata();
        if (autoMapping.source() != null && !autoMapping.source().isEmpty()) {
            metadata.setSource(autoMapping.source());
        } else {
            metadata.setSource(ele.getSimpleName().toString());
        }
        metadata.setTargetClass(targetClass);
        metadata.setTarget(autoMapping.target());
        metadata.setDefaultValue(autoMapping.defaultValue());
        metadata.setIgnore(autoMapping.ignore());
        metadata.setExpression(autoMapping.expression());
        metadata.setDateFormat(autoMapping.dateFormat());
        metadata.setNumberFormat(autoMapping.numberFormat());
        return metadata;
    }

    private ClassName transToClassName(Supplier<Class<?>> classSupplier) {
        TypeMirror typeMirror = null;
        try {
            Class<?> clazz = classSupplier.get();
        }
        catch (MirroredTypeException e) {
            typeMirror = e.getTypeMirror();
        }
        if (typeMirror == null) {
            return null;
        }
        return (ClassName)ClassName.get((TypeMirror)typeMirror);
    }

    private List<ClassName> transToClassNameList(Supplier<Class<?>[]> classSuppler) {
        List<? extends TypeMirror> typeMirrors = null;
        try {
            Class<?>[] classArray = classSuppler.get();
        }
        catch (MirroredTypesException e) {
            typeMirrors = e.getTypeMirrors();
        }
        return typeMirrors.stream().map(typeMirror -> (ClassName)ClassName.get((TypeMirror)typeMirror)).collect(Collectors.toList());
    }
}

