/*
 * Decompiled with CFR 0.152.
 */
package io.github.linpeilie.processor.generator;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import io.github.linpeilie.processor.AutoMapperProperties;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.tools.Diagnostic;

public class MapperConfigGenerator {
    public void write(ProcessingEnvironment processingEnv, String mapstructConfigName, String adapterClassName) {
        try (Writer writer = processingEnv.getFiler().createSourceFile(AutoMapperProperties.getConfigPackage() + "." + mapstructConfigName, new Element[0]).openWriter();){
            JavaFile.builder((String)AutoMapperProperties.getConfigPackage(), (TypeSpec)this.createConfigTypeSpec(mapstructConfigName, adapterClassName)).build().writeTo((Appendable)writer);
        }
        catch (IOException e) {
            processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error while opening " + AutoMapperProperties.getConfigClassName() + " output file: " + e.getMessage());
        }
    }

    private TypeSpec createConfigTypeSpec(String mapstructConfigName, String adapterClassName) {
        return TypeSpec.interfaceBuilder((String)mapstructConfigName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(this.buildMapperConfigAnnotationSpec(adapterClassName)).build();
    }

    private AnnotationSpec buildMapperConfigAnnotationSpec(String adapterClassName) {
        CodeBlock.Builder usesCodeBuilder = CodeBlock.builder().add("{", new Object[0]);
        usesCodeBuilder.add("$T.class", new Object[]{ClassName.get((String)AutoMapperProperties.getAdapterPackage(), (String)adapterClassName, (String[])new String[0])});
        CodeBlock usesCodeBlock = usesCodeBuilder.add("}", new Object[0]).build();
        AnnotationSpec.Builder builder = AnnotationSpec.builder((ClassName)ClassName.get((String)"org.mapstruct", (String)"MapperConfig", (String[])new String[0])).addMember("componentModel", CodeBlock.builder().add("$S", new Object[]{AutoMapperProperties.getComponentModel()}).build()).addMember("uses", usesCodeBlock);
        if (AutoMapperProperties.getUnmappedSourcePolicy() != null) {
            CodeBlock unmappedSourcePolicyCodeBlock = CodeBlock.builder().add("$T.$L", new Object[]{ClassName.get((String)"org.mapstruct", (String)"ReportingPolicy", (String[])new String[0]), AutoMapperProperties.getUnmappedSourcePolicy()}).build();
            builder.addMember("unmappedSourcePolicy", unmappedSourcePolicyCodeBlock);
        }
        if (AutoMapperProperties.getUnmappedTargetPolicy() != null) {
            CodeBlock unmappedTargetPolicyCodeBlock = CodeBlock.builder().add("$T.$L", new Object[]{ClassName.get((String)"org.mapstruct", (String)"ReportingPolicy", (String[])new String[0]), AutoMapperProperties.getUnmappedTargetPolicy()}).build();
            builder.addMember("unmappedTargetPolicy", unmappedTargetPolicyCodeBlock);
        }
        CodeBlock builderCodeBlock = CodeBlock.builder().add("@$T(buildMethod = $S, disableBuilder = $L)", new Object[]{ClassName.get((String)"org.mapstruct", (String)"Builder", (String[])new String[0]), AutoMapperProperties.getBuildMethod(), AutoMapperProperties.isDisableBuilder()}).build();
        builder.addMember("builder", builderCodeBlock);
        return builder.build();
    }
}

